<?php
namespace Mbe\Shipping\Block\Adminhtml\Sales\Shipment;


//class Mbe_Shipping_Block_Adminhtml_Sales_Shipment_Grid extends Mage_Adminhtml_Block_Sales_Shipment_Grid
class Grid extends \Magento\Backend\Block\Widget\Grid\Extended
{

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    protected $collectionFactory;

    public function __construct(
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Magento\Backend\Helper\Data $backendHelper,
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Sales\Model\ResourceModel\Order\Shipment\Grid\CollectionFactory $collectionFactory,
        array $data = []
    )
    {
        $this->shippingWsFactory = $shippingWsFactory;
        $this->shippingHelper = $shippingHelper;
        $this->collectionFactory = $collectionFactory;

        parent::__construct($context, $backendHelper, $data);

        $this->setId('mbe_shipping_grid');
        $this->setDefaultSort('increment_id');
        $this->setDefaultDir('DESC');
        $this->setSaveParametersInSession(true);
        $this->setUseAjax(true);
    }

    protected function _prepareCollection()
    {
        $collection = $this->collectionFactory->create();
        
        // get only shipments which has tracking number
        $collection->getSelect()->where('EXISTS (SELECT * FROM sales_shipment_track Where parent_id = main_table.entity_id)');
        
        $collection->join(array('orders' => 'sales_order'), 
        'main_table.order_id = orders.entity_id  AND orders.shipping_method like \''.\Mbe\Shipping\Helper\Data::MBE_SHIPPING_PREFIX.'%\'', array(
            'shipping_method' => 'shipping_method',
            //'country_id' => 'country_id'
        ));

        // $select = $collection->getSelect();
        // var_dump($select->__toString());

        /*
        $select = $collection->getSelect();
        var_dump($select->__toString());
        $id = 1;
        $select->where("main_table.entity_id = ?", $id);

        */

        //die();
        /*
        die();
        $select->where("address_table.country_id = ?", $country);
        $select->where("address_table.country_id = ?", $country);
        */
        
        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    protected function _filterTypeConditionCallback($collection, $column)
    {
        if (!$value = $column->getFilter()->getValue()) {
            return $this;
        }
        if (!empty($value)) {
            $this->getCollection()->getSelect()->where(
                "orders.shipping_method = '" . $value . "'");
        }

        //Useful to print query during development
        //$select = $collection->getSelect();
        //var_dump($select->__toString());


        return $this;
    }

    protected function _prepareColumns()
    {

        /** @var  $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();

        /** @var $helper Mbe_Shipping_Helper_Data */
        $helper = $this->shippingHelper;


        if ($ws->mustCloseShipments()) {


            $this->addColumn('status',
                array(
                    'header'    => __('Status'),
                    'width'     => '50px',
                    'filter'    => false,
                    'sortable'  => false,
                    'is_system' => true,
                    'renderer'  => 'Mbe\Shipping\Block\Adminhtml\Template\Grid\Renderer\Statusrenderer',
                ));
        }

        $this->addColumn('shipping_method',
            array(
                'header'    => __('Type'),
                'width'     => '50px',
                // 'filter'    => false,
                'sortable'  => false,
                'is_system' => true,

                'type'                      => 'options',
                'options'                   => $helper->getShippingTypesFromShipments(),
                'renderer'                  => 'Mbe\Shipping\Block\Adminhtml\Template\Grid\Renderer\Typerenderer',
                'filter_condition_callback' => array($this, '_filterHasUrlConditionCallback')
            ));


        $this->addColumn('increment_id', array(
            'header' => __('Shipment #'),
            'index'  => 'increment_id',
            'filter_index' => 'main_table.increment_id',
            'type'   => 'text',

        ));


        $this->addColumn('created_at', array(
            'header' => __('Date Shipped'),
            'index'  => 'created_at',
            'type'   => 'datetime',
        ));

        $this->addColumn('order_increment_id', array(
            'header' => __('Order #'),
            'index'  => 'order_increment_id',
            'type'   => 'text',
        ));

        $this->addColumn('order_created_at', array(
            'header' => __('Order Date'),
            'index'  => 'order_created_at',
            'type'   => 'datetime',
        ));

        $this->addColumn('shipping_name', array(
            'header' => __('Ship to Name'),
            'index'  => 'shipping_name',
        ));

        $this->addColumn('total_qty', array(
            'header' => __('Total Qty'),
            'index'  => 'total_qty',
            'type'   => 'number',
        ));


        //$link= Mage::helper('adminhtml')->getUrl('adminhtml/catalog_product/edit/') .'id/$entity_id';

        //http://magento.stackexchange.com/questions/4449/link-for-action-column-in-custom-grid


        $this->addColumn('action_download',
        array(
            'header'    => __('Download'),
            'width'     => '50px',
            'type'      => 'action',
            'getter'    => 'getId',
            'renderer'  => 'Mbe\Shipping\Block\Adminhtml\Template\Grid\Renderer\Downloadrenderer',
            'filter'    => false,
            'sortable'  => false,
            'is_system' => true
        ));


        $this->addColumn('action',
        array(
            'header'    => __('Action'),
            'width'     => '50px',
            'type'      => 'action',
            'getter'    => 'getId',
            'actions'   => array(
                array(
                    'caption' => __('View'),
                    'url'     => array('base' => 'sales/shipment/view'),
                    'field'   => 'shipment_id'
                ),
            ),
            'filter'    => false,
            'sortable'  => false,
            'is_system' => true
        ));


        $this->addExportType('*/*/exportCsv', __('CSV'));
        $this->addExportType('*/*/exportExcel', __('Excel XML'));

        return parent::_prepareColumns();
    }

    public function getGridUrl()
    {
        return $this->getUrl('*/*/grid', array('_current' => true));
    }

    /**
     * Prepare and set options for massaction
     *
     * @return Mage_Adminhtml_Block_Sales_Shipment_Grid
     */
    protected function _prepareMassaction()
    {
        /** @var  $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();

        /** @var $helper Mbe_Shipping_Helper_Data */
        $helper = $this->shippingHelper;
        if ($ws->mustCloseShipments()) {

            $this->setMassactionIdField('sales_shipment_grid.entity_id');
            $this->getMassactionBlock()->setFormFieldName('shipment_ids');
            $this->getMassactionBlock()->setUseSelectAll(false);

            $this->getMassactionBlock()->addItem('close_shippings', array(
                'label' => __('Close Shippings'),
                'url'   => $this->getUrl('*/*/closeshipments'),
            ));
        }
        
        return $this;
    }

}