<?php
namespace Mbe\Shipping\Block\Adminhtml\System\Config\Form\Fieldset\Shipping;


/**
 * Created by PhpStorm.
 * User: Samuele Carpene
 * Web: http://www.samuelecarpene.com
 * Date: 31/08/2016
 * Time: 13:03
 */
class Thresholds extends
    \Magento\Config\Block\System\Config\Form\Fieldset
{
    protected $_dummyElement;
    protected $_fieldRenderer;
    protected $_values;

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    /**
     * @var \Magento\Config\Block\System\Config\Form\Field
     */
    protected $configSystemConfigFormField;

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    /**
     * @var \Magento\Framework\DataObjectFactory
     */
    protected $dataObjectFactory;

    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Magento\Config\Block\System\Config\Form\Field $configSystemConfigFormField,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        \Magento\Framework\DataObjectFactory $dataObjectFactory,
        \Magento\Backend\Block\Context $context,
        \Magento\Backend\Model\Auth\Session $session,
        \Magento\Framework\View\Helper\Js $jsHelper
    ) {
        $this->dataObjectFactory = $dataObjectFactory;
        $this->shippingHelper = $shippingHelper;
        $this->configSystemConfigFormField = $configSystemConfigFormField;
        $this->shippingWsFactory = $shippingWsFactory;

        parent::__construct($context, $session, $jsHelper);

    }
    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        
        $helper = $this->shippingHelper;
        $allowedShipmentServicesArray = $helper->getAllowedShipmentServicesArray();
        
        $html = $this->_getHeaderHtml($element);
        
        foreach ($allowedShipmentServicesArray as $allowedShipmentService) {
            $html .= $this->_getFieldHtml($element, $allowedShipmentService);
        }
        $html .= $this->_getFooterHtml($element);

        return $html;
    }

    //this creates a dummy element so you can say if your config fields are available on default and website level - you can skip this and add the scope for each element in _getFieldHtml method
    protected function _getDummyElement()
    {
        if (empty($this->_dummyElement)) {
            $this->_dummyElement = $this->dataObjectFactory->create(array('show_in_default' => 1, 'show_in_website' => 1));
        }
        return $this->_dummyElement;
    }

    //this sets the fields renderer. If you have a custom renderer tou can change this.
    protected function _getFieldRenderer()
    {
        if (empty($this->_fieldRenderer)) {
            $this->_fieldRenderer = $this->configSystemConfigFormField;
        }
        return $this->_fieldRenderer;
    }

    //this is usefull in case you need to create a config field with type dropdown or multiselect. For text and texareaa you can skip it.
/*
    protected function _getValues()
    {
        if (empty($this->_values)) {
            $this->_values = array(
                array('label' => Mage::helper('adminhtml')->__('No'), 'value' => 0),
                array('label' => Mage::helper('adminhtml')->__('Yes'), 'value' => 1),
            );
        }
        return $this->_values;
    }
*/

    //this actually gets the html for a field
    protected function _getFieldHtml($fieldset, $shipmentType)
    {
        /**
         * @var $helper Mbe_Shipping_Helper_Data
         */
        $helper = $this->shippingHelper;

        $fieldName = $helper->getNameFromLabel($shipmentType);



        /** @var  $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();

        $fieldLabel = $ws->getLabelFromShipmentType($shipmentType);

        $configData = $this->getConfigData();
        $path = 'carriers/mbe_shipping/threshold_' . $fieldName;//this value is composed by the section name, group name and field name. The field name must not be numerical (that's why I added 'group_' in front of it)
        if (isset($configData[$path])) {
            $data = $configData[$path];
            $inherit = false;
        } else {
            //$data = (int)(string)$this->getForm()->getConfigRoot()->descend($path);
            $data ="";
            $inherit = true;
        }

        $e = $this->_getDummyElement();//get the dummy element

        $field = $fieldset->addField($fieldName, 'text',//this is the type of the element (can be text, textarea, select, multiselect, ...)
            array(
                //'name'                  => 'groups[demo][fields][group_' . $group->getId() . '][value]',//this is groups[group name][fields][field name][value]
                'name'  => 'groups[mbe_shipping][fields][threshold_' . $fieldName . '][value]',
                'label' => $fieldLabel,

                'value'                 => $data,//this is the current value
                //'values'                => $this->_getValues(),//this is necessary if the type is select or multiselect
                'inherit'               => $inherit,
                'can_use_default_value' => $this->getForm()->canUseDefaultValue($e),//sets if it can be changed on the default level
                'can_use_website_value' => $this->getForm()->canUseWebsiteValue($e),//sets if can be changed on website level
            ))->setRenderer($this->_getFieldRenderer());

        /*
        $field = $fieldset->addField($group->getId(), 'select',//this is the type of the element (can be text, textarea, select, multiselect, ...)
            array(
                'name'                  => 'groups[demo][fields][group_' . $group->getId() . '][value]',//this is groups[group name][fields][field name][value]
                'label'                 => $group->getCustomerGroupCode(),//this is the label of the element
                'value'                 => $data,//this is the current value
                'values'                => $this->_getValues(),//this is necessary if the type is select or multiselect
                'inherit'               => $inherit,
                'can_use_default_value' => $this->getForm()->canUseDefaultValue($e),//sets if it can be changed on the default level
                'can_use_website_value' => $this->getForm()->canUseWebsiteValue($e),//sets if can be changed on website level
            ))->setRenderer($this->_getFieldRenderer());
        */
        return $field->toHtml();
    }
}