<?php
namespace Mbe\Shipping\Block\Adminhtml\Template\Grid\Renderer;


class Downloadrenderer extends \Magento\Backend\Block\Widget\Grid\Column\Renderer\Action
{

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper
    ) {
        $this->shippingHelper = $shippingHelper;
    }
    public function render(\Magento\Framework\DataObject $row)
    {
        /** var $row Mage_Sales_Model_Order_Shipment */
        $result = "";
        /** @var  $helper Mbe_Shipping_Helper_Data */
        $helper = $this->shippingHelper;
        $shipmentIncrementId = $row->getIncrementId();

        $shipmentUrl = $helper->getShipmentUrl($shipmentIncrementId);

        if ($shipmentUrl) {
            if (is_array($shipmentUrl)) {
                foreach ($shipmentUrl as $singleShipmentUrl) {
                    if ($result != '') {
                        $result .= '<br>';
                    }
                    $result .= "<a href=\"" . $singleShipmentUrl . "\" target=\"_blank\">" . __("Download Waybill") . "</a>";
                }
            }
            else {
                $result = "<a href=\"" . $shipmentUrl . "\" target=\"_blank\">" . __("Download Waybill") . "</a>";
            }
        }

        return $result;
    }
}