<?php
namespace Mbe\Shipping\Controller\Adminhtml;


class Mbe extends \Magento\Backend\App\Action
{

    /**
     * @var \Magento\Backend\Model\Auth\Session
     */
    protected $backendAuthSession;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Backend\Helper\Data
     */
    protected $backendHelper;

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    public function __construct(
        \Magento\Backend\Model\Auth\Session $backendAuthSession,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Backend\Helper\Data $backendHelper,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory
    ) {
        $this->backendAuthSession = $backendAuthSession;
        $this->logger = $logger;
        $this->backendHelper = $backendHelper;
        $this->shippingWsFactory = $shippingWsFactory;
    }
    protected function _isAllowed()
    {
        return $this->backendAuthSession->isAllowed('admin/sales/mbe_shippings');
    }
    
    public function closeAction()
    {

        $this->logger->log(\Monolog\Logger::INFO, "Mbe_Shipping_Adminhtml_MbeController closeAction");


        $trackingNumber = $this->getRequest()->getParam('tracking_number');
        $shipmentId = $this->getRequest()->getParam('shipment_id');

        $shipmentUrl = $this->backendHelper->getUrl("adminhtml/sales_shipment/view", array('shipment_id' => $shipmentId));

        /** @var  $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();

        $ws->closeTrackingNumber($trackingNumber);

        Mage::app()->getResponse()->setRedirect($shipmentUrl)->sendResponse();
    }

    public function execute()
    {
        
    }
}
