<?php

namespace Mbe\Shipping\Model\Adminhtml\System\Config\Backend\Shipping;

use Magento\Framework\Filesystem;

class Shipping extends \Magento\Config\Model\Config\Backend\File
{

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    /**
     * @var \Mbe\Shipping\Helper\Csv
     */
    protected $shippingCsvHelper;

    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    protected $messageManager;

    /**
     * @var \Mbe\Shipping\Helper\Rates
     */
    protected $shippingRatesHelper;

    protected $configWriter;

    protected $filePath;
    
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\Config\ScopeConfigInterface $config,
        \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList,
        \Magento\MediaStorage\Model\File\UploaderFactory $uploaderFactory,
        \Magento\Config\Model\Config\Backend\File\RequestData\RequestDataInterface $requestData,
        Filesystem $filesystem,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,

        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Helper\Csv $shippingCsvHelper,
        \Mbe\Shipping\Helper\Rates $shippingRatesHelper,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Magento\Framework\App\Config\Storage\WriterInterface $configWriter,

        array $data = []
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->shippingCsvHelper = $shippingCsvHelper;
        $this->shippingRatesHelper = $shippingRatesHelper;
        $this->messageManager = $messageManager;
        $this->configWriter = $configWriter;

        parent::__construct(
           $context, $registry, $config, $cacheTypeList, $uploaderFactory, $requestData, $filesystem,
           $resource, $resourceCollection, $data
        );
    }

    public function beforeSave()
    {
        $mbeDir = $this->shippingHelper->mbeCsvUploadDir();

        $value = $this->getValue();
        $tmpName = $this->_requestData->getTmpName($this->getPath());
        $file = [];
        if ($tmpName) {
            $file['tmp_name'] = $tmpName;
            $file['name'] = $this->_requestData->getName($this->getPath());
        } elseif (!empty($value['tmp_name'])) {
            $file['tmp_name'] = $value['tmp_name'];
            $file['name'] = $value['value'];
        }

        if (!empty($file)) {
            $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
            if(!in_array($ext, $this->getAllowedExtensions()) ) {
                $this->messageManager->addError('The file extension should be CSV.');
                return false;
            }
            
            $nowDate = new \DateTime();
            $fileName = date_format($nowDate, 'Y-m-d_H-i-s') . '_' . 'mbe_csv.csv';
            $filePath = $mbeDir . DIRECTORY_SEPARATOR . $fileName;

            move_uploaded_file($file['tmp_name'], $filePath);

            $this->validateCsvFileAndInsert($filePath);
        } else {
            // get old value if no file uploaded
            $fileName = $this->shippingHelper->getShipmentsCsv();
        }

        $this->setValue($fileName);
    }

    public function validateCsvFileAndInsert($filePath)
    {
        /** @var $helper Mbe_Shipping_Helper_Data */
        $helper = $this->shippingHelper;
        /** @var $csvHelper Mbe_Shipping_Helper_Csv */
        $csvHelper = $this->shippingCsvHelper;

        $rates = array_filter($csvHelper->readFile($filePath));

        //VALIDATE

        $errors = false;
        $i = 1;

        $allowedShipmentServicesArray = $helper->getAllowedShipmentServices();
        //TODO:verify
        $maxShipmentWeight = $helper->getMaxShipmentWeight();

        foreach ($rates as $rate) {
            if (strlen($rate["country"]) > 2) {
                $this->messageManager->addError(sprintf(__('File upload error: row %d: "%s", COUNTRY column. Use destination Country in 2 character ISO format (e.g. IT for Italy, ES for Spain, DE for Germany)'), $i, $rate["country"]));
                $errors = true;
            }

            if (is_array($allowedShipmentServicesArray) && !in_array($rate["delivery_type"], $allowedShipmentServicesArray)) {
                $this->messageManager->addError(sprintf(__('File upload error: row %d: "%s", SHIPMENT TYPE column. Input code is not a valid MBE Service'), $i, $rate["delivery_type"]));
                $errors = true;
            }
            if ($maxShipmentWeight) {
                if ($rate["weight_from"] > $maxShipmentWeight) {
                    $this->messageManager->addError(sprintf(__('File upload error: row %d: "%s", WEIGHT column. Input weight exceeds allowed'), $i, $rate["weight_from"]));
                    $errors = true;
                }
                if ($rate["weight_to"] > $maxShipmentWeight) {
                    $this->messageManager->addError(sprintf(__('File upload error: row %d: "%s", WEIGHT column. Input weight exceeds allowed'), $i, $rate["weight_to"]));
                    $errors = true;
                }
            }
            $i++;
        }

        if ($errors) {
            return false;
        }
        
        //INSERT
        /** @var $ratesHelper Mbe_Shipping_Helper_Rates */
        $ratesHelper = $this->shippingRatesHelper;

        $truncateResult = $ratesHelper->truncate();

        if (!$truncateResult) {
            $this->messageManager->addError(__('Error executing truncate query '));
        }

        foreach ($rates as $rate) {
            $insertResult = $ratesHelper->insertRate($rate["country"], $rate["region"], $rate["city"], $rate["zip"], $rate["zip_to"], $rate["weight_from"], $rate["weight_to"], $rate["price"], $rate["delivery_type"]);

            if (!$insertResult) {
                $this->messageManager->addError(__('Error executing query '));
            }
        }
    }

    public function getAllowedExtensions() {
        return ['csv'];
    }
}
