<?php
namespace Mbe\Shipping\Model;

use Magento\Framework\Event\ObserverInterface;

class NewOrderObserver implements ObserverInterface
{

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    /**
     * @var \Mbe\Shipping\Helper\Logger
     */
    protected $shippingLoggerHelper;

    protected $salesOrderFactory;
    
    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Helper\Logger $shippingLoggerHelper,
        \Magento\Sales\Model\OrderFactory $salesOrderFactory
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->shippingLoggerHelper = $shippingLoggerHelper;
        $this->salesOrderFactory = $salesOrderFactory;
    }
    /**
     * Check if order need to create mbe shipping
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if ($this->shippingHelper->isEnabled()) {
            $order = $this->salesOrderFactory->create()->load($observer->getDataByKey('order_ids'));

            //only if order is shipped with mbe
            if ($this->shippingHelper->isMbeShipping($order)) {
                $stateNew = \Magento\Sales\Model\Order::STATE_NEW;
                $paymentMethod = $order->getPayment()->getMethodInstance()->getCode();
                
                if ($order->getState() == $stateNew && $paymentMethod == "cashondelivery") {
                    $this->shippingLoggerHelper->log("NewOrderObserver - cashondelivery");

                    $order->setIsInProcess(true)->save();
                }
            }
        }

        return $this;
    }
}