<?php

namespace Mbe\Shipping\Block\Adminhtml\Sales\Shipment;

use Mbe\Shipping\Model\Ws;
use Mbe\Shipping\Block\Adminhtml\Template\Grid\Renderer\Typerenderer;
use Mbe\Shipping\Block\Adminhtml\Template\Grid\Renderer\Statusrenderer;
use Mbe\Shipping\Block\Adminhtml\Template\Grid\Renderer\Downloadrenderer;

class Grid extends \Magento\Backend\Block\Widget\Grid\Extended
{

    protected $shippingWsFactory;
    protected $shippingHelper;
    protected $collectionFactory;

    public function __construct(
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Magento\Backend\Helper\Data $backendHelper,
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Sales\Model\ResourceModel\Order\Shipment\Grid\CollectionFactory $collectionFactory,
        array $data = []
    ) {
        $this->shippingWsFactory = $shippingWsFactory;
        $this->shippingHelper = $shippingHelper;
        $this->collectionFactory = $collectionFactory;

        parent::__construct($context, $backendHelper, $data);

        $this->setId('mbe_shipping_grid');
        $this->setDefaultSort('increment_id');
        $this->setDefaultDir('DESC');
        $this->setSaveParametersInSession(true);
        $this->setUseAjax(true);
    }

    public function getGridUrl()
    {
        return $this->getUrl('*/*/grid', ['_current' => true]);
    }

    protected function _prepareCollection()
    {
        $collection = $this->collectionFactory->create();

        // get only shipments which has tracking number
        $collection->getSelect()->where(
            'EXISTS (SELECT * FROM sales_shipment_track Where parent_id = main_table.entity_id)'
        );

        $collection->join(
            ['orders' => 'sales_order'],
            'main_table.order_id = orders.entity_id  AND'.
            '(orders.shipping_method like \'' . \Mbe\Shipping\Helper\Data::MBE_SHIPPING_PREFIX . '%\' OR '.
            'orders.is_mbe_custom_mapping)',
            [
                'shipping_method' => 'shipping_method',
            ]
        );

        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    protected function _filterTypeConditionCallback($collection, $column)
    {
        if (!$value = $column->getFilter()->getValue()) {
            return $this;
        }
        if (!empty($value)) {
            $this->getCollection()->getSelect()->where("orders.shipping_method = '" . $value . "'");
        }

        return $this;
    }

    protected function _prepareColumns()
    {

        $ws = $this->shippingWsFactory->create();
        $helper = $this->shippingHelper;

        if ($ws->mustCloseShipments()) {

            $this->addColumn(
                'status',
                [
                    'header' => __('Status'),
                    'width' => '50px',
                    'filter' => false,
                    'sortable' => false,
                    'is_system' => true,
                    'renderer' => Statusrenderer::class,
                ]
            );
        }

        $this->addColumn(
            'shipping_method',
            [
                'header' => __('Type'),
                'width' => '50px',
                'sortable' => false,
                'is_system' => true,
                'type' => 'options',
                'options' => $helper->getShippingTypesFromShipments(),
                'renderer' => Typerenderer::class,
            ]
        );


        $this->addColumn('increment_id', [
            'header' => __('Shipment #'),
            'index' => 'increment_id',
            'filter_index' => 'main_table.increment_id',
            'type' => 'text',

        ]);


        $this->addColumn('created_at', [
            'header' => __('Date Shipped'),
            'index' => 'created_at',
            'filter_index' => 'main_table.created_at',
            'type' => 'datetime',
        ]);

        $this->addColumn('order_increment_id', [
            'header' => __('Order #'),
            'index' => 'order_increment_id',
            'type' => 'text',
        ]);

        $this->addColumn('order_created_at', [
            'header' => __('Order Date'),
            'index' => 'order_created_at',
            'type' => 'datetime',
        ]);

        $this->addColumn('shipping_name', [
            'header' => __('Ship to Name'),
            'index' => 'shipping_name',
        ]);

        $this->addColumn('total_qty', [
            'header' => __('Total Qty'),
            'index' => 'total_qty',
            'type' => 'number',
        ]);

        $this->addColumn(
            'action_download',
            [
                'header' => __('Download'),
                'width' => '50px',
                'type' => 'action',
                'getter' => 'getId',
                'renderer' => Downloadrenderer::class,
                'filter' => false,
                'sortable' => false,
                'is_system' => true
            ]
        );


        $this->addColumn(
            'action',
            [
                'header' => __('Action'),
                'width' => '50px',
                'type' => 'action',
                'getter' => 'getId',
                'actions' => [
                    [
                        'caption' => __('View'),
                        'url' => ['base' => 'sales/shipment/view'],
                        'field' => 'shipment_id'
                    ],
                ],
                'filter' => false,
                'sortable' => false,
                'is_system' => true
            ]
        );


        $this->addExportType('*/*/exportCsv', __('CSV'));
        $this->addExportType('*/*/exportExcel', __('Excel XML'));

        return parent::_prepareColumns();
    }

    /**
     * Prepare and set options for massaction
     */
    protected function _prepareMassaction()
    {
        $ws = $this->shippingWsFactory->create();
        $helper = $this->shippingHelper;
        if ($ws->mustCloseShipments()) {

            $this->setMassactionIdField('main_table.entity_id');
            $this->getMassactionBlock()->setFormFieldName('shipment_ids');
            $this->getMassactionBlock()->setUseSelectAll(false);

            $this->getMassactionBlock()->addItem('close_shippings', [
                'label' => __('Close Shippings'),
                'url' => $this->getUrl('*/*/closeshipments'),
            ]);
        }

        return $this;
    }

}
