<?php

namespace Mbe\Shipping\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Sales\Model\Order;

class SalesModelServiceQuoteSubmitBefore implements ObserverInterface
{
    protected $quoteRepository;

    public function __construct(
        CartRepositoryInterface $quoteRepository
    ) {
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        /** @var $order Order */
        $order = $observer->getOrder();
        if ($observer->getEvent()->getQuote()->getmbeShippingUapShipment()) {
            $order->setData('mbe_shipping_uap_shipment', true);
            $order->addCommentToStatusHistory('<strong>'.strtoupper(__('Ship to UAP')).'</strong>');
        }
    }

}
