<?php

namespace Mbe\Shipping\Plugin\Block\Checkout;

use Magento\Checkout\Model\Session;
use Mbe\Shipping\Helper\Data;
use Mbe\Shipping\Model\Carrier as MbeCarrier;

class LayoutProcessorPlugin
{

    protected $shippingHelper;

    public function __construct(
        Data $shippingHelper
    ) {
        $this->shippingHelper = $shippingHelper;
    }

    public function afterProcess(\Magento\Checkout\Block\Checkout\LayoutProcessor $subject, $jsLayout)
    {
        if (!($this->shippingHelper->isEnabled() && $this->shippingHelper->getShipToUap())) {
            // remove the uap select component
            unset(
                $jsLayout["components"]["checkout"]["children"]["steps"]["children"]["shipping-step"]["children"]
                ["shippingAddress"]["children"]["shippingAdditional"]["children"]["mbe-uap-list-wrapper"]
            );
        }
        return $jsLayout;
    }
}
