<?php

namespace Mbe\Shipping\Plugin\Model;

use Magento\Checkout\Model\ShippingInformationManagement;
use Magento\Checkout\Api\Data\ShippingInformationInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Mbe\Shipping\Helper\Data;

/**
 * Update the shipping address using the selected UAP
 * Class ShippingInformationManagementPlugin
 */
class ShippingInformationManagementPlugin
{
    protected $shippingHelper;
    protected $quoteRepository;

    public function __construct(
        Data $shippingHelper,
        CartRepositoryInterface $quoteRepository
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->quoteRepository = $quoteRepository;
    }

    public function beforeSaveAddressInformation(
        ShippingInformationManagement $subject,
        $cartId,
        ShippingInformationInterface $addressInformation
    ) {
        if ($this->shippingHelper->isEnabled() && $this->shippingHelper->getShipToUap()) {
            $mbe_uap_address = json_decode(stripslashes($addressInformation->getExtensionAttributes()->getMbeShippingUapData()));
            if (!empty($mbe_uap_address)) {
                // set quote custom field
                $quote = $this->quoteRepository->getActive($cartId);
                $quote->setmbeShippingUapShipment(true);

                // SET THE ADDRESS VALUES AGAIN JUST TO BE SURE THEY MATCH UAP ONES
                $shippingAddress = $addressInformation->getShippingAddress();
                // set empty values
                $shippingAddress->setCustomerAddressId(null);
                $shippingAddress->setRegionCode(null);
                $shippingAddress->setFax(null);

                // do not add it to the address book
                $shippingAddress->setSaveInAddressBook(false);
                // do not set same as billing
                $shippingAddress->setSameAsBilling(false);

                // set the data to be sure we are using the billing ones
//                $shippingAddress->setTelephone($addressInformation->getBillingAddress()->getTelephone());
//                $shippingAddress->setFirstname($addressInformation->getBillingAddress()->getFirstname());
//                $shippingAddress->setLastname($addressInformation->getBillingAddress()->getLastname());

                // Set the address values
                $shippingAddress->setCountryId($mbe_uap_address->CountryCode);
                $shippingAddress->setCompany($mbe_uap_address->ConsigneeName);
                $shippingAddress->setStreet($mbe_uap_address->AddressLine);
                $shippingAddress->setCity($mbe_uap_address->PoliticalDivision2);
                $shippingAddress->setPostcode($mbe_uap_address->PostcodePrimaryLow);
                $shippingAddress->setRegion($mbe_uap_address->PoliticalDivision1);

                return [$cartId, $addressInformation];
            }
        }
        return null;
    }

}
