<?php

namespace Mbe\Shipping\Controller\Uap;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Quote\Model\MaskedQuoteIdToQuoteId;
use Mbe\Shipping\Helper\UpsUap;
use Magento\Quote\Api\CartRepositoryInterface;

class CheckShipment extends Action implements HttpGetActionInterface
{
    protected $upsUapHelper;
    protected $cartRepository;
    protected $jsonFactory;
    protected $quoteIdMaskFactory;

    public function __construct(
        Context $context,
        UpsUap $upsUapHelper,
        CartRepositoryInterface $cartRepository,
        JsonFactory $jsonFactory,
        MaskedQuoteIdToQuoteId $quoteIdMaskFactory
    )
    {
        $this->jsonFactory = $jsonFactory;
        $this->upsUapHelper = $upsUapHelper;
        $this->cartRepository = $cartRepository;
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        parent::__construct($context);
    }

    public function execute()
    {
        $result = $this->jsonFactory->create();
        $request = json_decode($this->getRequest()->getParam('data'));
        try {
            $cart = $this->cartRepository->get($request->quoteId);
        } catch (NoSuchEntityException $e) {
            try {
                // check if the cart is a guest cart
                $unmaskedId = $this->quoteIdMaskFactory->execute($request->quoteId);
                $cart = $this->cartRepository->get($unmaskedId);
            } catch (NoSuchEntityException $e) {
                return $result->setData(false);
            }
        } catch (\Exception $e) {
            return $result->setData(false);
        }
        return $result->setData($this->upsUapHelper->checkConditions($cart, $request->countryId));
    }

}
