<?php
namespace Mbe\Shipping\Helper;

use Magento\Framework\Escaper;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Shipping\Model\Config;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    private $_mbeMediaDir = "mbe";
    private $_csvDir = 'csv';
    const MBE_SHIPPING_PREFIX = "mbe_shipping_";
    const XML_PATH_SHIPMENT = 'carriers/mbe_shipping';

    //MAIN
    const XML_PATH_DEBUG = 'carriers/mbe_shipping/debug';
    const XML_PATH_ENABLED = 'carriers/mbe_shipping/active';
    const XML_PATH_COUNTRY = 'carriers/mbe_shipping/country';
    //WS
    const XML_PATH_WS_URL = 'carriers/mbe_shipping/url';
    const XML_PATH_WS_USERNAME = 'carriers/mbe_shipping/username';
    const XML_PATH_WS_PASSWORD = 'carriers/mbe_shipping/password';
    //OPTIONS
    const XML_PATH_DESCRIPTION = 'carriers/mbe_shipping/description';
    const XML_PATH_DEFAULT_SHIPMENT_TYPE = 'carriers/mbe_shipping/default_shipment_type';
    const XML_PATH_ALLOWED_SHIPMENT_SERVICES = 'carriers/mbe_shipping/allowed_shipment_services';
    const XML_PATH_SHIPMENT_CONFIGURATION_MODE = 'carriers/mbe_shipping/shipment_configuration_mode';

    const HANDLING_TYPE_PERCENT = 'P';
    const HANDLING_TYPE_FIXED = 'F';

    const XML_PATH_DEFAULT_LENGTH = 'carriers/mbe_shipping/default_length';
    const XML_PATH_DEFAULT_WIDTH = 'carriers/mbe_shipping/default_width';
    const XML_PATH_WEIGHT_UOM = 'carriers/mbe_shipping/weight_uom';
    const XML_PATH_DEFAULT_HEIGHT = 'carriers/mbe_shipping/default_height';
    const XML_PATH_MAX_PACKAGE_WEIGHT = 'carriers/mbe_shipping/max_package_weight';
    const XML_PATH_MAX_SHIPMENT_WEIGHT = 'carriers/mbe_shipping/max_shipment_weight';
    const XML_PATH_HANDLING_TYPE = 'carriers/mbe_shipping/handling_type';
    const XML_PATH_HANDLING_ACTION = 'carriers/mbe_shipping/handling_action';
    const XML_PATH_HANDLING_FEE = 'carriers/mbe_shipping/handling_fee';
    const XML_PATH_HANDLING_FEE_ROUNDING = 'carriers/mbe_shipping/handling_fee_rounding';
    const XML_PATH_HANDLING_FEE_ROUNDING_AMOUNT = 'carriers/mbe_shipping/handling_fee_rounding_amount';
    const XML_PATH_SALLOWSPECIFIC = 'carriers/mbe_shipping/sallowspecific';
    const XML_PATH_SPECIFICCOUNTRY = 'carriers/mbe_shipping/specificcountry';
    const XML_PATH_SORT_ORDER = 'carriers/mbe_shipping/sort_order';
    const XML_PATH_MAXIMUM_TIME_FOR_SHIPPING_BEFORE_THE_END_OF_THE_DAY = 'carriers/mbe_shipping/maximum_time_for_shipping_before_the_end_of_the_day';
    const XML_PATH_SPECIFICERRMSG = 'carriers/mbe_shipping/specificerrmsg';
    const XML_PATH_WEIGHT_TYPE = 'carriers/mbe_shipping/weight_type';
    const XML_PATH_SHIPMENTS_CLOSURE_MODE = 'carriers/mbe_shipping/shipments_closure_mode';
    const XML_PATH_SHIPMENTS_CLOSURE_TIME = 'carriers/mbe_shipping/shipments_closure_time';
    const XML_PATH_SHIPMENTS_CREATION_MODE = 'carriers/mbe_shipping/shipments_creation_mode';

    const XML_PATH_SHIPMENTS_CSV = 'carriers/mbe_shipping/shipments_csv';
    const XML_PATH_SHIPMENTS_CSV_FILE = 'carriers/mbe_shipping/shipments_csv_file';

    const XML_PATH_SHIPMENTS_CSV_MODE = 'carriers/mbe_shipping/shipments_csv_mode';
    const XML_PATH_SHIPMENTS_CSV_INSURANCE_MIN = 'carriers/mbe_shipping/mbe_shipments_csv_insurance_min';
    const XML_PATH_SHIPMENTS_CSV_INSURANCE_PERCENTAGE = 'carriers/mbe_shipping/mbe_shipments_csv_insurance_per';
    const XML_PATH_SHIPMENTS_INSURANCE_MODE = 'carriers/mbe_shipping/mbe_shipments_ins_mode';

    const MBE_FREE_SHIPMENT_THRESHOLD_GROUP_ID = 'mbe_shipping_thresholds';
    const XML_PATH_THRESHOLD = 'carriers/mbe_shipping_thresholds';

    const MBE_SHIPMENT_CUSTOM_LABEL_PREFIX = 'custom_label_';

    const XML_PATH_ENABLE_CUSTOM_MAPPING = 'carriers/mbe_shipping/enable_custom_mapping';
    const MBE_SHIPMENT_CUSTOM_MAPPING_PREFIX = 'custom_mapping_';

    const XML_PATH_SHIP_TO_UAP = 'carriers/mbe_shipping/mbe_ship_to_UAP';

    //const

    const MBE_SHIPMENT_STATUS_CLOSED = "Closed";
    const MBE_SHIPMENT_STATUS_OPEN = "Opened";

    const MBE_CLOSURE_MODE_AUTOMATICALLY = 'automatically';
    const MBE_CLOSURE_MODE_MANUALLY = 'manually';

    const MBE_CREATION_MODE_AUTOMATICALLY = 'automatically';
    const MBE_CREATION_MODE_MANUALLY = 'manually';

    const MBE_CSV_MODE_DISABLED = 'disabled';
    const MBE_CSV_MODE_TOTAL = 'total';
    const MBE_CSV_MODE_PARTIAL = 'partial';
    const MBE_INSURANCE_WITH_TAXES = 'insurance_with_taxes';
    const MBE_INSURANCE_WITHOUT_TAXES = 'insurance_without_taxes';
    const MBE_SHIPPING_WITH_INSURANCE_CODE_SUFFIX = '_INSURANCE';
    const MBE_SHIPPING_WITH_INSURANCE_LABEL_SUFFIX = ' + Insurance';
    const MBE_SHIPPING_TRACKING_SEPARATOR = ',';
    const MBE_SHIPPING_TRACKING_SEPARATOR__OLD = '--';

    const XML_PATH_CURRENT_CSV = 'carriers/mbe_shipping/current_csv';

    const XML_PATH_CACHEDCUSTOMERDATA = 'carriers/mbe_shipping/cachedcustomerdata';

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     *
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Sales\Model\Order\ShipmentFactory
     */
    protected $salesOrderShipmentFactory;

    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\CollectionFactory
     */
    protected $salesResourceModelOrderCollectionFactory;

    /**
     *
     * @var \Magento\Framework\Filesystem\DirectoryList
     */
    protected $_dir;

    /**
     *
     * @var \Magento\Sales\Model\Order\Shipment
     */
    protected $shipment;

    /**
     *
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    protected $mediaUrl;

    protected $fileSystem;

    protected $serializer;

    protected $escaper;

    protected $config;

    protected $orderRepository;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        \Magento\Sales\Model\Order\ShipmentFactory $salesOrderShipmentFactory,
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $salesResourceModelOrderCollectionFactory,
        \Magento\Framework\Filesystem\DirectoryList $dir,
        \Magento\Sales\Model\Order\ShipmentRepository $shipment,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\Filesystem\Io\File $fileSystem,
        \Magento\Framework\Serialize\SerializerInterface $serializer,
        OrderRepositoryInterface $orderRepository,
        Escaper $escaper,
        Config $config
    ) {
        $this->shippingWsFactory = $shippingWsFactory;
        $this->salesOrderShipmentFactory = $salesOrderShipmentFactory;
        $this->salesResourceModelOrderCollectionFactory = $salesResourceModelOrderCollectionFactory;
        $this->_dir = $dir;
        $this->shipment = $shipment;
        $this->storeManager = $storeManager;
        $this->mediaUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
        $this->fileSystem = $fileSystem;
        $this->serializer = $serializer;
        $this->escaper = $escaper;
        $this->config = $config;
        $this->orderRepository = $orderRepository;
        parent::__construct(
            $context
        );
    }


    public function checkMbeDir()
    {
        $mediaDir = $this->_dir->getPath('media');
        $mbeDir = $mediaDir . DIRECTORY_SEPARATOR . $this->_mbeMediaDir;
        if (!file_exists($mbeDir)) {
            mkdir($mbeDir);
        }

        $mbeCsvDir = $mbeDir . DIRECTORY_SEPARATOR . $this->_csvDir;

        if (!file_exists($mbeCsvDir)) {
            mkdir($mbeCsvDir);

            $appDir = $this->_dir->getPath('app');
            copy($appDir.'/code/Mbe/Shipping/Templates/mbe_csv_template.csv', $mbeCsvDir . '/mbe_csv_template.csv');
        }
    }

    /**
     * @return string
     */
    public function getPluginVersion()
    {
        $composerFile = $this->fileSystem->read(__DIR__.'/../composer.json');
        if ($composerFile) {
            $plugin_data = $this->serializer->unserialize($composerFile);
            return $plugin_data['version'];
        }
        return '';
    }

    //TODO: check if is necessary to specify storeid or get current storeid
    public function isEnabled($storeId = null)
    {
        /** @var $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();
        $result = $ws->isCustomerActive() && $this->scopeConfig->getValue(self::XML_PATH_ENABLED, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
        return $result;
    }

    public function debug($storeId = null)
    {
        $result = ($this->scopeConfig->getValue(self::XML_PATH_DEBUG, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId) == 1);
        return $result;
    }

    public function getCountry($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_COUNTRY, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }


    public function getWsUrl($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_WS_URL, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getWsUsername($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_WS_USERNAME, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getWsPassword($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_WS_PASSWORD, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getDescription($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_DESCRIPTION, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getDefaultShipmentType($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_DEFAULT_SHIPMENT_TYPE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getAllowedShipmentServices($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_ALLOWED_SHIPMENT_SERVICES, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShipToUap($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIP_TO_UAP, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function convertShippingCodeWithInsurance($code)
    {
        return $code . self::MBE_SHIPPING_WITH_INSURANCE_CODE_SUFFIX;
    }

    public function convertShippingLabelWithInsurance($label)
    {
        return $label . self::MBE_SHIPPING_WITH_INSURANCE_LABEL_SUFFIX;
    }

    public function convertShippingCodeWithoutInsurance($code)
    {
        return str_replace(self::MBE_SHIPPING_WITH_INSURANCE_CODE_SUFFIX, "", $code);
    }

    public function isShippingWithInsurance($code)
    {
        $result = false;
        /*
        $shippingSuffix = substr($code, -strlen(self::MBE_SHIPPING_WITH_INSURANCE_CODE_SUFFIX));
        if ($shippingSuffix == self::MBE_SHIPPING_WITH_INSURANCE_CODE_SUFFIX) {
            $result = true;
        }
        */
        if (strpos($code, self::MBE_SHIPPING_WITH_INSURANCE_CODE_SUFFIX) !== false) {
            $result = true;
        }
        return $result;
    }

    public function getAllowedShipmentServicesArray($storeId = null)
    {
        $allowedShipmentServices = $this->getAllowedShipmentServices($storeId);

        $result = array();
        $allowedShipmentServicesArray = array();

        if ($allowedShipmentServices != "") {
            $allowedShipmentServicesArray = explode(",", $allowedShipmentServices);
        }

        /** @var $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();
        $canSpecifyInsurance = $ws->getCustomerPermission('canSpecifyInsurance');

        foreach ($allowedShipmentServicesArray as $item) {
            $canAdd = true;
            if (!$canSpecifyInsurance) {
                if (strpos($item, self::MBE_SHIPPING_WITH_INSURANCE_CODE_SUFFIX) !== false) {
                    $canAdd = false;
                }
            }
            if ($canAdd) {
                array_push($result, $item);
            }
        }

        return $result;
    }

    public function getShipmentConfigurationMode($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENT_CONFIGURATION_MODE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getDefaultLength($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_DEFAULT_LENGTH, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getDefaultWidth($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_DEFAULT_WIDTH, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getDefaultHeight($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_DEFAULT_HEIGHT, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getMaxPackageWeight($storeId = null)
    {
        $result = $this->scopeConfig->getValue(self::XML_PATH_MAX_PACKAGE_WEIGHT, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
        /** @var $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();

        if ($this->getDefaultShipmentType() == "ENVELOPE") {
            $maxParcelWeight = 0.5;
        }
        else {
            $maxParcelWeight = $ws->getCustomerPermission("maxParcelWeight");
        }

        if ($maxParcelWeight > 0 && $maxParcelWeight < $result) {
            $result = $maxParcelWeight;
        }
        return $result;
    }

    public function getMaxShipmentWeight($storeId = null)
    {
        $result = $this->scopeConfig->getValue(self::XML_PATH_MAX_SHIPMENT_WEIGHT, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
        /** @var $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();

        if ($this->getDefaultShipmentType() == "ENVELOPE") {
            $maxShipmentWeight = 0.5;
        }
        else {
            $maxShipmentWeight = $ws->getCustomerPermission("maxShipmentWeight");
        }

        if ($maxShipmentWeight > 0 && $maxShipmentWeight < $result) {
            $result = $maxShipmentWeight;
        }
        return $result;
    }

    public function getHandlingType($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_HANDLING_TYPE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getHandlingAction($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_HANDLING_ACTION, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getHandlingFee($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_HANDLING_FEE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getHandlingFeeRounding($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_HANDLING_FEE_ROUNDING, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getHandlingFeeRoundingAmount($storeId = null)
    {
        $result = 1;
        if ($this->scopeConfig->getValue(self::XML_PATH_HANDLING_FEE_ROUNDING_AMOUNT, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId) == 2) {
            $result = 0.5;
        }
        return $result;
    }

    public function getSallowspecific($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SALLOWSPECIFIC, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getSpecificcountry($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SPECIFICCOUNTRY, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getSortOrder($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SORT_ORDER, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getMaximumTimeForShippingBeforeTheEndOfTheDay($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_MAXIMUM_TIME_FOR_SHIPPING_BEFORE_THE_END_OF_THE_DAY, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getSpecificerrmsg($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SPECIFICERRMSG, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getWeightType($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_WEIGHT_TYPE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShipmentsClosureMode($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENTS_CLOSURE_MODE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShipmentsClosureTime($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENTS_CLOSURE_TIME, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShipmentsCreationMode($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENTS_CREATION_MODE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }


    public function round($value)
    {
        $result = $value;
        $handlingFeeRounding = $this->getHandlingFeeRounding();
        $handlingFeeRoundingAmount = $this->getHandlingFeeRoundingAmount();

        if ($handlingFeeRounding == 2) {

            if ($handlingFeeRoundingAmount == 1) {
                $result = round($value, 0);
            }
            else {
                $result = round($value, 2);
            }

        }
        elseif ($handlingFeeRounding == 3) {
            if ($handlingFeeRoundingAmount == 1) {
                $result = floor($value);
            }
            else {
                $result = floor($value * 2) / 2;
            }
        }
        elseif ($handlingFeeRounding == 4) {
            if ($handlingFeeRoundingAmount == 1) {
                $result = ceil($value);
            }
            else {
                $result = ceil($value * 2) / 2;
            }
        }
        return $result;
    }


    public function testRound($value)
    {
        $valueRounded = $this->round($value);
    }

    public function getNameFromLabel($label)
    {
        $name = $label;
        $name = strtolower($name);
        $name = str_replace(" ", "_", $name);
        $name = str_replace(" ", "_", $name);
        return $name;
    }

    public function getThresholdByShippingServrice($shippingService, $storeId = null)
    {
        $shippingService = strtolower($shippingService);
        return $this->escaper->escapeHtml($this->scopeConfig->getValue(
            self::XML_PATH_THRESHOLD . "/" . $shippingService,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $storeId
        ));
    }


    public function getTrackingStatus($trackingNumber)
    {
        $result = self::MBE_SHIPMENT_STATUS_OPEN;

        $mediaDir = $this->_dir->getPath('media');
        $mbeDir = $mediaDir . DIRECTORY_SEPARATOR . 'mbe';
        $filePath = $mbeDir . DIRECTORY_SEPARATOR . $trackingNumber . ".pdf";

        if (file_exists($filePath)) {
            $result = self::MBE_SHIPMENT_STATUS_CLOSED;
        }
        return $result;
    }

    public function isShippingOpen($shipmentId)
    {
        $result = true;
        $shipment = $this->shipment->get($shipmentId);
        $tracks = $shipment->getAllTracks();
        foreach ($tracks as $track) {
            $trackingNumber = $track->getTrackNumber();
            $result = $result && $this->isTrackingOpen($trackingNumber);
        }
        return $result;
    }

    public function isTrackingOpen($trackingNumber)
    {
        return $this->getTrackingStatus($trackingNumber) == self::MBE_SHIPMENT_STATUS_OPEN;
    }


    public function getShipmentFilePath($shipmentIncrementId, $ext)
    {
        $this->checkMbeDir();
        $mediaDir = $this->_dir->getPath('media');
        $mbeDir = $mediaDir . DIRECTORY_SEPARATOR . $this->_mbeMediaDir;
        $filePath = $mbeDir . DIRECTORY_SEPARATOR . $shipmentIncrementId . "." . $ext;
        return $filePath;
    }

    public function getShipmentUrlByShipmentId($shipmentId)
    {
        $shipment = $this->salesOrderShipmentFactory->create()->load($shipmentId);

        return $this->getShipmentUrl($shipment->getIncrementId());
    }

    public function getShipmentUrl($shipmentIncrementId)
    {
        $result = false;
        $mbeUrl = $this->mediaUrl . $this->_mbeMediaDir . '/';
        $ext = "pdf";

        if (file_exists($this->getShipmentFilePath($shipmentIncrementId, "pdf"))) {
            $result = $mbeUrl . $shipmentIncrementId . ".pdf";
        }
        elseif (file_exists($this->getShipmentFilePath($shipmentIncrementId, "html"))) {
            $result = $mbeUrl . $shipmentIncrementId . ".html";
        }
        elseif (file_exists($this->getShipmentFilePath($shipmentIncrementId, "gif"))) {
            $result = $mbeUrl . $shipmentIncrementId . ".gif";
        }
        else {
            $foundFiles = true;
            $i = 1;
            $resultFiles = array();
            do {

                if (file_exists($this->getShipmentFilePath($shipmentIncrementId . '_' . $i, "pdf"))) {
                    $resultFiles[] = $mbeUrl . $shipmentIncrementId . '_' . $i . ".pdf";
                }
                elseif (file_exists($this->getShipmentFilePath($shipmentIncrementId . '_' . $i, "html"))) {
                    $resultFiles[] = $mbeUrl . $shipmentIncrementId . '_' . $i . ".html";
                }
                elseif (file_exists($this->getShipmentFilePath($shipmentIncrementId . '_' . $i, "gif"))) {
                    $resultFiles[] = $mbeUrl . $shipmentIncrementId . '_' . $i . ".gif";
                }
                else {
                    $foundFiles = false;
                }
                $i++;

            } while ($foundFiles);

            $result = $resultFiles;
        }

        return $result;
    }

    public function getTrackingFilePath($trackingNumber)
    {
        $this->checkMbeDir();
        $mediaDir = $this->_dir->getPath('media');
        $mbeDir = $mediaDir . DIRECTORY_SEPARATOR . $this->_mbeMediaDir;
        $filePath = $mbeDir . DIRECTORY_SEPARATOR . $trackingNumber . ".pdf";
        return $filePath;
    }

    public function getTrackingUrlByShipmentId($shipmentId)
    {
        $shipment = $this->shipment->get($shipmentId);
        $tracks = $shipment->getAllTracks();
        foreach ($tracks as $track) {
            $trackingNumber = $track->getTrackNumber();
            return $this->getTrackingUrl($trackingNumber);
        }
    }

    public function getTrackingUrl($trackingNumber)
    {
        $mbeUrl = $this->mediaUrl . $this->_mbeMediaDir . '/';
        $fileUrl = $mbeUrl . $trackingNumber . ".pdf";
        return $fileUrl;
    }


    public function getShippingTypesFromShipments()
    {
        $result = array();

        $ws = $this->shippingWsFactory->create();
        $collection = $this->salesResourceModelOrderCollectionFactory->create()->addFieldToSelect('shipping_method');

        $collection->getSelect()->group('shipping_method');

        foreach ($collection as $col) {
            $shippingMethodCode = $this->getShippingCodeFromMagentoShippingMethod($col->getShippingMethod());
            $shippingMethodLabel = $ws->getLabelFromShipmentType($shippingMethodCode);

            if ($this->isShippingWithInsurance($col->getShippingMethod())) {
                $shippingMethodLabel = $this->convertShippingLabelWithInsurance($shippingMethodLabel);
            }
            $result[$col->getShippingMethod()] = $shippingMethodLabel;
        }
        return $result;
    }


    public function getShipmentLabel($shipmentCode)
    {
        /** @var $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();

        return $ws->getLabelFromShipmentType($shipmentCode);
    }

    public function getShipmentLabelFromMagentoShippingMethod($shipmentCode)
    {
        $shippingMethod = $this->getShippingCodeFromMagentoShippingMethod($shipmentCode);
        $result = $this->getShipmentLabel($shippingMethod);
        if ($this->isShippingWithInsurance($shipmentCode)) {
            $result = $this->convertShippingLabelWithInsurance($result);
        }
        return $result;
    }

    public function isMbeShippingCustomMapping($shippingCarrier)
    {
        // double check it's not a mbe shipping method and custom mapping is enabled
        // Due to Magento bug , the carrier code is retrieved as 'mbe' instead of 'mbe_shipping'
        if ($shippingCarrier !== 'mbe' && $this->isEnabledCustomMapping()) {
            $customMapping = $this->getCustomMappingShippingMethods();
            if (isset($customMapping[$shippingCarrier]) && !empty($customMapping[$shippingCarrier])) {
                return true;
            }
        }
        return false;
    }

    public function isMbeShipping($order)
    {
        $shippingMethod = $order ? $order->getShippingMethod() : null;
        // Check if the methods is an MBE one or if is a custom mapped default one
        if (strpos($shippingMethod, self::MBE_SHIPPING_PREFIX) !== false
            || $this->isMbeShippingCustomMapping($order->getShippingMethod(true)->getCarrierCode())
        ){
            return true;
        }
        return false;
    }

    /**
     * @param $order \Magento\Sales\Model\Order
     */
    public function getShippingMethod($order)
    {
        $order_item_id = $order->getId();

        if ($order_item_id) {
            $shippingCarrier = $order->getShippingMethod(true)->getCarrierCode();
            $shippingMethod = $order->getShippingMethod();
            $customMapping = $this->getShippingCustomMapping($shippingCarrier);
            if (!empty($customMapping)) {
                $shippingMethod = $customMapping;
            }
            return $shippingMethod;
        } else {
            return false;
        }
    }

    public function getShippingCustomMappingOptions()
    {
        /** @var $ws Mbe_Shipping_Model_Ws */
        $ws = $this->shippingWsFactory->create();

        $availableShipping = $ws->getAllowedShipmentServices();
        $selectedOptions = [];
        foreach ($this->getAllowedShipmentServicesArray() as $key => $value) {
            $index = array_search($value, array_column($availableShipping, 'value'));
            $label = '';
            if (isset($availableShipping[$index]['label'])) {
                $label = __($availableShipping[$index]['label'])->getText();
            }
            $selectedOptions[] = [
                "label" => $label,
                "value" => $value
            ];
        }
        return $selectedOptions;
    }

    public function getCustomMappingShippingMethods()
    {
        $defaultMethods = $this->getDefaultShippingMethods();
        $customMapping = [];
        foreach ($defaultMethods as $default_method) {
            $mapping = $this->getShippingCustomMapping(strtolower($default_method->getId()));
            if (!empty($mapping)) {
                $customMapping[$default_method->getId()] = strtolower($mapping);
            }
        }
        return $customMapping;
    }

    public function getDefaultShippingMethods()
    {
        $filterMethods = ['flatrate'=>'', 'freeshipping'=>'', 'tablerate'=>''];
        return array_intersect_key($this->config->getActiveCarriers(), $filterMethods);
    }

    public function isEnabledCustomMapping($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_ENABLE_CUSTOM_MAPPING, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShippingCustomMapping($shippingCarrier)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENT .'/'. self::MBE_SHIPMENT_CUSTOM_MAPPING_PREFIX .$shippingCarrier);
    }


    public function setOrderCustomMappingInfo($order)
    {
        try {
            // Add custom mapping flag for shipment list and comment to track it
            if ($this->isMbeShippingCustomMapping($order->getShippingMethod(true)->getCarrierCode())
                && $order
            ) {
                if (!$order->getIsMbeCustomMapping()) { // check if the flag and comment are alredy set
                    $ws = $this->shippingWsFactory->create();
                    $order->setIsMbeCustomMapping(true); // set the custom mapping flag
                    $carrierCode = $order->getShippingMethod(true)->getCarrierCode();
                    $shippingMbeMethod = $this->getShippingCustomMapping($carrierCode);

                    $availableShipping = $ws->getAllowedShipmentServices();
                    $index = array_search($shippingMbeMethod, array_column($availableShipping, 'value'));
                    if (isset($availableShipping[$index]['label'])) {
                        $customMappingDescription = __($availableShipping[$index]['label'])->getText();
                    }

                    $order->addCommentToStatusHistory(
                        __('Custom mapping for %1', $this->scopeConfig->getValue('carriers/' . $carrierCode . '/title')) .
                        ' - ' .
                        $customMappingDescription
                    );

                    $order->save();
                }
                return true;
            }
        } catch (NoSuchEntityException|InputException $e) {
            return false;
        }
        return false;
    }
//    public function getMbeShippingType($order)
//    {
//        $result = "";
//        $shippingMethod = $order->getShippingMethod();
//        if (strpos($shippingMethod, self::MBE_SHIPPING_PREFIX) !== false) {
//
//            $result = $this->getShippingCodeFromMagentoShippingMethod($shippingMethod);
//        }
//        return $result;
//    }

    public function getShippingParamFromMagentoShippingMethod($shippingMethod, $i)
    {
        $shippingMethodWithSubZone = str_replace(self::MBE_SHIPPING_PREFIX, '', $shippingMethod);

        $shippingMethodWithSubZoneArray = explode('_', $shippingMethodWithSubZone);
        if (isset($shippingMethodWithSubZoneArray[$i])) {
            return $shippingMethodWithSubZoneArray[$i];
        }
        return null;
    }

    public function getShippingCodeFromMagentoShippingMethod($shippingMethod)
    {
        return $this->getShippingParamFromMagentoShippingMethod($shippingMethod, 0);
    }

    public function getShippingSubZoneFromMagentoShippingMethod($shippingMethod)
    {
        return $this->getShippingParamFromMagentoShippingMethod($shippingMethod, 1);
    }

    public function getShipmentsCsv($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENTS_CSV, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShipmentsCsvMode($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENTS_CSV_MODE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShipmentsCsvInsuranceMin($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENTS_CSV_INSURANCE_MIN, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShipmentsCsvInsurancePercentage($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENTS_CSV_INSURANCE_PERCENTAGE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getShipmentsInsuranceMode($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_SHIPMENTS_INSURANCE_MODE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function mbeUploadDir()
    {
        $this->checkMbeDir();
        $mediaDir = $this->_dir->getPath('media');
        $mbeDir = $mediaDir . DIRECTORY_SEPARATOR . $this->_mbeMediaDir;
        return $mbeDir;
    }

    public function mbeCsvUploadDir()
    {
        $result = $this->mbeUploadDir() . DIRECTORY_SEPARATOR . $this->_csvDir;
        return $result;
    }

    public function getCurrentCsvUrl()
    {
        $fileName = $this->getShipmentsCsv();
        $result = $this->mediaUrl . $this->_mbeMediaDir . '/' . $this->_csvDir . '/' . $fileName;
        return $result;
    }

    public function getCsvTemplateUrl()
    {
        $result = $this->mediaUrl . $this->_mbeMediaDir . '/' . $this->_csvDir . '/' . 'mbe_csv_template.csv';
        return $result;
    }

    public function getProductTitleFromOrderItem($item)
    {
        $title = $item->getName();

        if ($item->getProductType() == "configurable") {
            $options = $item->getProductOptions();

            if (isset($options['simple_name'])) {
                $title .= ' - ' . $options['simple_name'];
            }
            $variationsString = '';
            if (isset($options['attributes_info'])) {
                foreach ($options['attributes_info'] as $attributesInfo) {
                    if ($variationsString != '') {
                        $variationsString .= ', ';
                    }

                    $variationsString .= $attributesInfo['label'] . ': ' . $attributesInfo['value'];
                }
            }

            if ($variationsString) {
                $title .= ' (' . $variationsString . ')';
            }
        }

        return $title;
    }

    public function convertWeight($weight, $toUnit = 'kgs')
    {
        if (is_array($weight)) {
            foreach ($weight as $key => $value) {
                $weight[$key] = self::getWeight($value, $toUnit);
            }
            return $weight;
        } else {
            return self::getWeight($weight, $toUnit);
        }
    }

    /**
     * Normalise weights, unify to kg then convert to wanted unit value.
     *
     * Usage:
     * wc_get_weight(55, 'kgs');
     * wc_get_weight(55, 'kgs', 'lbs');
     *
     * @param int|float $weight    Weight.
     * @param string    $to_unit   Unit to convert to.
     *                             Options: 'g', 'kgs', 'lbs', 'oz'.
     * @param string    $from_unit Unit to convert from.
     *                             Defaults to ''.
     *                             Options: 'g', 'kgs', 'lbs', 'oz'.
     * @return float
     */
    public function getWeight($weight, $to_unit, $from_unit = '')
    {
        $weight  = (float) $weight;
        $to_unit = strtolower($to_unit);

        if (empty($from_unit)) {
            $from_unit = strtolower($this->scopeConfig->getValue(\Magento\Directory\Helper\Data::XML_PATH_WEIGHT_UNIT));
        }

        // Unify all units to kg first.
        if ($from_unit !== $to_unit) {
            switch ($from_unit) {
                case 'g':
                    $weight *= 0.001;
                    break;
                case 'lbs':
                    $weight *= 0.453592;
                    break;
                case 'oz':
                    $weight *= 0.0283495;
                    break;
            }

            // Output desired unit.
            switch ($to_unit) {
                case 'g':
                    $weight *= 1000;
                    break;
                case 'lbs':
                    $weight *= 2.20462;
                    break;
                case 'oz':
                    $weight *= 35.274;
                    break;
            }
        }

        return ($weight < 0) ? 0 : $weight;
    }

    public function getShippingMethodCustomLabel($methodCode)
    {
        $customLabel = trim($this->scopeConfig->getValue(
            self::XML_PATH_SHIPMENT . '/' . self::MBE_SHIPMENT_CUSTOM_LABEL_PREFIX . strtolower($methodCode)
        ));
        if (!empty($customLabel)) {
            return $this->escaper->escapeHtml($customLabel);
        }
        return false;
    }

    /**
     * Insert the elements of an array into an existing one after a specified keys (if found) or append it to the end
     * @param array $arrayInto Array to which the data must be added
     * @param array $arrayFrom Array of data to be added
     * @param null $afterKey Key to search in the main array
     */
    public function insertIntoArray(&$arrayInto, $arrayFrom, $afterKey = null)
    {
        if ($afterKey) {
            $pos = array_search($afterKey, array_keys($arrayInto));
            if ($pos !== false) {
                $arrayInto = array_merge(
                    array_slice($arrayInto, 0, $pos+1, true),
                    $arrayFrom,
                    array_slice($arrayInto, $pos+1, null, true)
                );
            }
        }
        array_merge($arrayInto, $arrayFrom);
    }
}
