<?php

namespace Mbe\Shipping\Helper;

use \Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Quote\Api\Data\CartInterface;
use Mbe\Shipping\Model\Carrier as MbeCarrier;

class UpsUap extends AbstractHelper
{

    const MBE_UPS_ACCESS_LICENSE_NUMBER = "6CB804D87F868625";
    const MBE_UPS_USER_ID = "ITMBE0001Z";
    const MBE_UPS_PASSWORD = "1tMB3#ooo1";
    const MBE_UPS_URI_TEST = "https://wwwcie.ups.com/ups.app/xml/Locator";
    const MBE_UPS_URI_PROD = "https://onlinetools.ups.com/ups.app/xml/Locator";
    const MBE_UPS_DEFAULT_MAXIMUM_LIST_SIZE_10 = "10";
    const MBE_UPS_DEFAULT_SEARCH_RADIUS_20 = "20";
    const MBE_UPS_DEFAULT_UNIT_OF_MEASUREMENT = "KM";
    const MBE_UPS_OPTION_DROP_LOCATIONS_AND_WILL_CALL_LOCATIONS = 1;
    const MBE_UPS_OPTION_ALL_AVAILABLE_ADDITIONAL_SERVICES = 8;
    const MBE_UPS_OPTION_ALL_AVAILABLE_PROGRAM_TYPES = 16;
    const MBE_UPS_OPTION_ALL_AVAILABLE_ADDITIONAL_SERVICES_AND_PROGRAM_TYPES = 24;
    const MBE_UPS_OPTION_ALL_AVAILABLE_RETAIL_LOCATIONS = 32;
    const MBE_UPS_OPTION_ALL_AVAILABLE_RETAIL_LOCATIONS_AND_ADDITIONAL_SERVICES = 40;
    const MBE_UPS_OPTION_ALL_AVAILABLE_RETAIL_LOCATIONS_AND_PROGRAM_TYPES = 48;
    const MBE_UPS_OPTION_ALL_AVAILABLE_RETAIL_LOCATIONS_AND_ADDITIONAL_SERVICES_AND_PROGRAM_TYPES = 56;
    const MBE_UPS_OPTION_UPS_ACCESS_POINT_LOCATIONS = 64;

    protected $shippingHelper;

    public function __construct(
        Context $context,
        Data $shippingHelper
    )
    {
        $this->shippingHelper = $shippingHelper;
        parent::__construct($context);
    }

    public function getUapList(
        $filter,
        $simplyfied = true,
        $userId = null,
        $password = null,
        $accessLicenseNumber = null,
        $test = false
    ) {
        $accessLicenseNumber = $accessLicenseNumber ?: self::MBE_UPS_ACCESS_LICENSE_NUMBER;
        $userId = $userId ?: self::MBE_UPS_USER_ID;
        $password = $password ?: self::MBE_UPS_PASSWORD;

        $endpointurl = self::MBE_UPS_URI_PROD;
        if ($test) {
            $endpointurl = self::MBE_UPS_URI_TEST;
        }

        try {
            $accessRequestXML = new \SimpleXMLElement("<AccessRequest></AccessRequest>");
            $locatorRequestXML = new \SimpleXMLElement("<LocatorRequest ></LocatorRequest >");

            $accessRequestXML->addChild("AccessLicenseNumber", $accessLicenseNumber);
            $accessRequestXML->addChild("UserId", $userId);
            $accessRequestXML->addChild("Password", $password);

            $request = $locatorRequestXML->addChild('Request');
            $request->addChild("RequestAction", "Locator");
            $request->addChild("RequestOption", isset($filter["RequestOption"]) ?$filter["RequestOption"]: self::MBE_UPS_OPTION_DROP_LOCATIONS_AND_WILL_CALL_LOCATIONS);

            $translate = $locatorRequestXML->addChild('Translate');
            $translate->addChild("LanguageCode", isset($filter["language"]) ?$filter["language"]: 'EN');

//			if(!empty($filter["LocationID"])) {
//				$locatorRequestXML->addChild ( "LocationID", $filter["LocationID"]);
//			} else {
            $originAddress = $locatorRequestXML->addChild('OriginAddress');
            $addressKeyFormat = $originAddress->addChild('AddressKeyFormat');
            $addressKeyFormat->addChild("AddressLine1", isset($filter["AddressLine1"]) ?$filter["AddressLine1"]: '');
            $addressKeyFormat->addChild("PostcodePrimaryLow", isset($filter["PostcodePrimaryLow"]) ?$filter["PostcodePrimaryLow"]: '');
            $addressKeyFormat->addChild("PoliticalDivision2", isset($filter["PoliticalDivision2"]) ?$filter["PoliticalDivision2"]: '');
            $addressKeyFormat->addChild("PoliticalDivision1", isset($filter["PoliticalDivision1"]) ?$filter["PoliticalDivision1"]: '');
            $addressKeyFormat->addChild("CountryCode", isset($filter["CountryCode"]) ?$filter["CountryCode"]: '');


            $unitOfMeasurement = $locatorRequestXML->addChild('UnitOfMeasurement');
            $unitOfMeasurement->addChild("Code", isset($filter["UnitOfMeasurement"]) ?$filter["UnitOfMeasurement"]: self::MBE_UPS_DEFAULT_UNIT_OF_MEASUREMENT);

            $LocationSearchCriteria = $locatorRequestXML->addChild('LocationSearchCriteria');
            $LocationSearchCriteria->addChild("MaximumListSize", isset($filter["MaximumListSize"]) ?$filter["MaximumListSize"]: self::MBE_UPS_DEFAULT_MAXIMUM_LIST_SIZE_10);
            $LocationSearchCriteria->addChild("SearchRadius", isset($filter["SearchRadius"]) ?$filter["SearchRadius"]: self::MBE_UPS_DEFAULT_SEARCH_RADIUS_20);

            $SortCriteria = $locatorRequestXML->addChild('SortCriteria');
            $SortCriteria->addChild('SortType', "01");
//			}

            $requestXML = $accessRequestXML->asXML() . $locatorRequestXML->asXML();

            $form = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => "$requestXML"
                )
            );

            $request = stream_context_create($form);
            $browser = fopen($endpointurl, 'rb', false, $request);
            if (!$browser) {
                throw new Exception("Connection failed.");
            }

            // get response
            $response = stream_get_contents($browser);
            fclose($browser);

            $upsUapList = null;

            if ($response == false) {
                throw new Exception("Bad data.");
            } else {
                $xmlResponse = simplexml_load_string($response);
                unset($response);
                unset($xmlResponse->Response);
                $xmlResponse = json_decode(json_encode($xmlResponse), true);
                if (!empty($xmlResponse)) {
                    if ($simplyfied) {
                        $dropLocation = $xmlResponse['SearchResults']['DropLocation'];
                        if (isset($dropLocation['LocationID'])) {
                            $upsUapList[] = $dropLocation['AddressKeyFormat'] + ['LocationID' => $dropLocation['LocationID']] + ['Distance' => $dropLocation['Distance']['Value'].' '.$dropLocation['Distance']['UnitOfMeasurement']['Code']] + ['StandardHoursOfOperation' => $dropLocation['StandardHoursOfOperation']];
                        } else {
                            foreach ($dropLocation as $item) {
                                $upsUapList[] = $item['AddressKeyFormat'] + [ 'LocationID' => $item['LocationID']] + ['Distance' => $item['Distance']['Value'].' '.$item['Distance']['UnitOfMeasurement']['Code']] + ['StandardHoursOfOperation' => $item['StandardHoursOfOperation']];
                            }
                        }
                        return $upsUapList;
                    }
                    return $xmlResponse;
                }
                return null;
            }
        } catch (Exception $ex) {
            return $ex;
        }
    }

    public function checkConditions(CartInterface $cart, $countryId)
    {
        // Parameter values
        $weightLimit = 20;
        $allowedCountriesList = ['IT', 'FR', 'GB', 'ES', 'DE', 'PL'];

        $weightOk = true; // Default value
        $cartWeight = 0;

        $cartProducts = $cart->getAllItems();

        foreach ($cartProducts as $cartProduct) {
            // calculate the cart weight
            $cartWeight += $cartProduct->getWeight() * $cartProduct->getQty();
            // check the single product weight
            if ($cartProduct->getWeight() > $weightLimit) {
                $weightOk = false;
            }
        }

        if (!($this->shippingHelper->getShipmentConfigurationMode() == MbeCarrier::SHIPMENT_CONFIGURATION_MODE_ONE_SHIPMENT_PER_ITEM)) {
            $weightOk = (
                ($cartWeight <= (float)$weightLimit) && ($cartWeight <= $this->shippingHelper->getMaxPackageWeight())
            );
        }

        $countryOK = in_array(strtoupper($countryId), $allowedCountriesList);
        $oneParcel = (
            ($weightOk && in_array($this->shippingHelper->getShipmentConfigurationMode(), [MbeCarrier::SHIPMENT_CONFIGURATION_MODE_ONE_SHIPMENT_PER_SHOPPING_CART_SINGLE_PARCEL, MbeCarrier::SHIPMENT_CONFIGURATION_MODE_ONE_SHIPMENT_PER_ITEM]))
            ||
            ($weightOk && $cart->getItemsQty() === 1 && $this->shippingHelper->getShipmentConfigurationMode() == MbeCarrier::SHIPMENT_CONFIGURATION_MODE_ONE_SHIPMENT_PER_SHOPPING_CART_MULTI_PARCEL)
        );

        if (($oneParcel && $countryOK
            // && $mbeServiceSelected
        )) {
            return true;
        }
        return false;
    }
}
