<?php
namespace Mbe\Shipping\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\App\ObjectManager;
use Mbe\Shipping\Helper\Data;

class AddMailVariabletrackingNumber implements ObserverInterface
{

    /**
     * @var Data
     */
    protected $helper;

    protected $trackingHelper;

    public function __construct(Data $helper, \Mbe\Shipping\Helper\Tracking $trackingHelper)
    {
        $this->helper = $helper;
        $this->trackingHelper = $trackingHelper;
    }

    /**
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $transport = $observer->getData('transportObject');
        $track_ids = '';
        foreach ($transport->getOrder()->getTracksCollection() as $item) {
             $track_ids .= '<br><a href="'.
                 $this->trackingHelper->getTrackingUrlBySystem($this->helper->getCountry()).
                 $item->getTrackNumber().
                 '">'.
                 $item->getTrackNumber().'</a>';
        }
        $transport->setMbeTrackid((!empty($track_ids)?('<br>'.__('MBE Tracking :')):'').$track_ids);
    }
}
