<?php

namespace Mbe\Shipping\Observer;

use Magento\Framework\EntityManager\EventManager;
use Magento\Framework\Event\ObserverInterface;
use Mbe\Shipping\Helper\Data;

class MbeSalesOrderShipmentSave implements ObserverInterface
{
    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    /**
     * @var \Mbe\Shipping\Helper\Logger
     */
    protected $shippingLoggerHelper;

    protected $eventManager;

    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Helper\Logger $shippingLoggerHelper,
        EventManager $eventManager

    ) {
        $this->shippingHelper = $shippingHelper;
        $this->shippingLoggerHelper = $shippingLoggerHelper;
        $this->eventManager = $eventManager;
    }

    /**
     * Check if the order need to be verified for mbe shipping
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this|void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $invoiceShip = $observer->getDataByKey('invoiceShip')?:false;
        $mbeShipment = $observer->getDataByKey('mbeShipment')?:false;
        $order = $observer->getDataByKey('order');
        // Check if the order need the MBE custom mapping flag and comment
        if ($this->shippingHelper->isEnabled() && $this->shippingHelper->isEnabledCustomMapping()) {
            $this->shippingHelper->setOrderCustomMappingInfo($order);
        }

        if (
            (!$mbeShipment && $this->shippingHelper->getShipmentsCreationMode() === Data::MBE_CREATION_MODE_AUTOMATICALLY)
            ||
            ($invoiceShip && $this->shippingHelper->getShipmentsCreationMode() === Data::MBE_CREATION_MODE_MANUALLY)
        ) {
            //dispatch mbe_sales_order_save_after
            $this->eventManager->dispatch('mbe_sales_order_save_after', [
                'order' => $order,
                'comment' => $observer->getDataByKey('comment'),
                'mbeShipment' => $mbeShipment
            ]);
        }
        return $this;
    }
}
