<?php

namespace Mbe\Shipping\Preference;

use Magento\Backend\App\Action\Context;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Backend\Model\View\Result\Redirect;
use Magento\Sales\Model\Order\Email\Sender\ShipmentSender;
use Magento\Sales\Model\Order\Shipment\ShipmentValidatorInterface;
use Magento\Shipping\Controller\Adminhtml\Order\Shipment\Save;
use Magento\Shipping\Controller\Adminhtml\Order\ShipmentLoader;
use Magento\Shipping\Model\Shipping\LabelGenerator;
use Mbe\Shipping\Helper\Data;
use Psr\Log\LoggerInterface;

class ShipmentCreate extends Save
{
    protected $shippingHelper;
    protected $orderRepository;

    /**
     * @param Data $shippingHelper
     * @param OrderRepositoryInterface $orderRepository
     * @param Context $context
     * @param ShipmentLoader $shipmentLoader
     * @param LabelGenerator $labelGenerator
     * @param ShipmentSender $shipmentSender
     * @param ShipmentValidatorInterface|null $shipmentValidator
     */
    public function __construct(
        Data $shippingHelper,
        OrderRepositoryInterface $orderRepository,
        Context $context,
        ShipmentLoader $shipmentLoader,
        LabelGenerator $labelGenerator,
        ShipmentSender $shipmentSender,
        ShipmentValidatorInterface $shipmentValidator = null
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->orderRepository = $orderRepository;
        parent::__construct($context, $shipmentLoader, $labelGenerator, $shipmentSender, $shipmentValidator);
    }

    public function execute()
    {
        if ($this->shippingHelper->isEnabled()) {
            $order = $this->orderRepository->get($this->getRequest()->getParam('order_id'));
            if (isset($order) && $this->shippingHelper->isMbeShipping($order)) {
                /** @var Redirect $resultRedirect */
                $resultRedirect = $this->resultRedirectFactory->create();
                $redirectPath = $resultRedirect->setPath(
                    'sales/order/view',
                    ['order_id' => $order->getId()]
                );
                try {
                    if ($order->canShip()) { // check this just to speed up the process
                        $data = $this->getRequest()->getParam('shipment');
                        $this->_eventManager->dispatch(
                            'mbe_sales_order_shipment_create',
                            ['order' => $order, 'comment' => $data['comment_text']]
                        );
                        return $redirectPath;
                    } else {
                        $message = 'Order cannot be shipped.';
                        $this->_objectManager->get(LoggerInterface::class)->critical($message);
                        $this->messageManager->addErrorMessage($this->__($message));
                        return $redirectPath;
                    }
                } catch (\Exception $e) {
                    $this->_objectManager->get(LoggerInterface::class)->critical($e);
                    $this->messageManager->addErrorMessage($this->__('Cannot save shipment.'));
                    return $redirectPath;
                }
            }
        }
        return parent::execute();
    }
}
