<?php

namespace Mbe\Shipping\Setup;

use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use \Magento\Framework\DB\Ddl\Table;

class UpgradeSchema implements \Magento\Framework\Setup\UpgradeSchemaInterface
{

    /**
     * @inheritDoc
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {

        if (version_compare($context->getVersion(), '2.3.0', '>=') &&
            version_compare($context->getVersion(), '2.4.0', '<')
        ) {
            $installer = $setup;
            $installer->startSetup();

            $orderTable = $installer->getTable('sales_order');

            $columns = [
                'is_mbe_custom_mapping' => [
                    'type' => Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'default' => false,
                    'comment' => 'MBE Custom mapping shipment order'
                ]
            ];

            $connection = $installer->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($orderTable, $name, $definition);
            }

            $installer->endSetup();
        }

        if (version_compare($context->getVersion(), '2.4.1', '<')
        ) {
            $installer = $setup;
            if ( $installer->getConnection()->tableColumnExists($installer->getTable('sales_order'), 'mbe_shipping_uap_shipment') === false) {
                $installer->startSetup();
                $quoteTable = $installer->getTable('quote');
                $orderTable = $installer->getTable('sales_order');

                $columns = [
                    'mbe_shipping_uap_shipment' => [
                        'type' => Table::TYPE_BOOLEAN,
                        'nullable' => false,
                        'default' => false,
                        'comment' => 'MBE Shipment Ship to UAP'
                    ]
                ];

                $connection = $installer->getConnection();

                foreach ($columns as $name => $definition) {
                    $connection->addColumn($quoteTable, $name, $definition);
                    $connection->addColumn($orderTable, $name, $definition);
                }

                $installer->endSetup();
            }
        }
    }

}
