<?php

namespace Mbe\Shipping\Observer;

use Magento\Framework\EntityManager\EventManager;
use Magento\Framework\Event\ObserverInterface;
use Magento\Paypal\Controller\Adminhtml\Billing\Agreement\OrdersGrid;
use Magento\Sales\Controller\Adminhtml\Order\Grid;
use Magento\TestFramework\Bootstrap\Settings;
use Mbe\Shipping\Helper\Data;

class MbeSalesOrderShipmentCreate implements ObserverInterface
{
    protected $scopeconfig;
    protected $helper;
    protected $mbeShipment = false;
    protected $eventManager;

    public function __construct(
        Data $data,
        EventManager $eventManager
    ) {
        $this->helper = $data;
        $this->eventManager = $eventManager;
    }

    /**
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $this->eventManager->dispatch('mbe_sales_order_save_after', [
            'order' => $observer->getDataByKey('order'),
            'comment' => $observer->getDataByKey('comment'),
            'mbeShipment' => true
        ]);
        return $this;
    }

}
