<?php

namespace Mbe\Shipping\Block\Adminhtml\Sales\Shipment;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Data\Form\Element\AbstractElement;

class WeightField extends \Magento\Config\Block\System\Config\Form\Field
{
    protected $scopeConfig;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        ScopeConfigInterface $scopeConfig,
        array $data = []
    ) {
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context, $data);
    }

    /**
     * Render weight field adding unit of measure to the label
     *
     * @param AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->setLabel(
            __($element->getLabel()) . ' (' .
            $this->scopeConfig->getValue(\Magento\Directory\Helper\Data::XML_PATH_WEIGHT_UNIT) .
            ')'
        );
        return parent::render($element);
    }
}
