<?php
namespace Mbe\Shipping\Block\Adminhtml\Shipping;


class Shipment extends \Magento\Framework\View\Element\Template
{
    protected $helper;
    protected $ws;

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    public $shippingHelper;

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;

    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        \Magento\Framework\Registry $registry,
        array $data = []
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->shippingWsFactory = $shippingWsFactory;
        $this->registry = $registry;
        parent::__construct(
            $context,
            $data
        );
    }

    public function _construct()
    {

        $this->helper = $this->shippingHelper;

        $this->ws = $this->shippingWsFactory->create();
    }

//    public function getShippingStatus()
//    {
//        return $this->getTrackingArray();
//    }

    public function getTrackingArray()
    {
        $result = array();
        $tracks = $this->getShipment()->getAllTracks();
        foreach ($tracks as $track) {

            if ($track->getCarrierCode() == "mbe_shipping") {
                $trackingNumber = $track->getTrackNumber();
                $current = array(
                    'tracking_number' => $trackingNumber,
                    'status'          => $this->helper->getTrackingStatus($trackingNumber),
                );

                array_push($result, $current);
            }
        }
        return $result;
    }


    /**
     * Retrieve shipment model instance
     *
     * @return \Magento\Sales\Model\Order\Shipment
     */
    public function getShipment()
    {
        return $this->registry->registry('current_shipment');
    }

    public function getShipmentIncrementId()
    {
        return $this->getShipment()->getIncrementId();
    }

    public function getShipmentId()
    {
        return $this->getShipment()->getId();
    }

    public function getOrder()
    {
        return $this->getShipment() ? $this->getShipment()->getOrder() : null;
    }

    public function mustCloseShipments()
    {
        return $this->ws->mustCloseShipments();
    }

}
