<?php
namespace Mbe\Shipping\Block\Adminhtml\System\Config\Form\Field;


class Downloadtemplate extends \Magento\Config\Block\System\Config\Form\Field
{

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Magento\Backend\Block\Template\Context $context,
        array $data = []
    ) {
        $this->shippingHelper = $shippingHelper;

        parent::__construct($context, $data);
    }

    protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $this->setElement($element);

        $buttonBlock = $this->getLayout()->createBlock('Magento\Backend\Block\Widget\Button');

        $downloadFileUrl = $this->shippingHelper->getCsvTemplateUrl();

        $data = array(
            'label'   => __('Download template file'),
            'onclick' => 'setLocation(\'' . $downloadFileUrl . '\' )',
            'class'   => '',
        );

        $html = $buttonBlock->setData($data)->toHtml();

        return $html;
    }


}
