<?php

namespace Mbe\Shipping\Controller\Uap;

use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Action\Action;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Exception\NotFoundException;
use Magento\Framework\Locale\Resolver;
use Mbe\Shipping\Helper\UpsUap;

class Getlist extends Action implements HttpGetActionInterface
{
    protected $jsonFactory;
    protected $upsUap;
    protected $resolver;

    public function __construct(
        Context $context,
        JsonFactory $jsonFactory,
        UpsUap $upsUap,
        Resolver $resolver
    ) {
        $this->jsonFactory = $jsonFactory;
        $this->upsUap = $upsUap;
        $this->resolver = $resolver;
        parent::__construct($context);
    }

    /**
     * Execute action based on request and return result
     *
     * @return \Magento\Framework\Controller\Result\Json
     * @throws NotFoundException
     */
    public function execute()
    {
        $uapFilter = json_decode($this->getRequest()->getParam('filter'), true);
        $uapFilter['language'] = explode('_', $this->resolver->getLocale())[0];
        $uapFilter['MaximumListSize'] = '20';
//        $uapFilter['SearchRadius'] ='20';
        $uapList = $this->upsUap->getUapList($uapFilter);
        $result = $this->jsonFactory->create();
        return $result->setData($uapList);
    }
}
