<?php
namespace Mbe\Shipping\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\EntityManager\EventManager;
use Magento\Framework\Event\ObserverInterface;
use Mbe\Shipping\Helper\Data;

class NewOrderObserver implements ObserverInterface
{

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    /**
     * @var \Mbe\Shipping\Helper\Logger
     */
    protected $shippingLoggerHelper;

    protected $orderRepository;

    protected $eventManager;

//    protected $scopeConfig;

//    protected $ws;

    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Helper\Logger $shippingLoggerHelper,
        \Magento\Sales\Model\OrderRepository $orderRepository,
        EventManager $eventManager
//        ScopeConfigInterface $scopeConfig,
//        Ws $ws
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->shippingLoggerHelper = $shippingLoggerHelper;
        $this->orderRepository = $orderRepository;
        $this->eventManager = $eventManager;
//        $this->scopeConfig = $scopeConfig;
//        $this->ws = $ws;
    }
    /**
     * Check if order need to create mbe shipping
     * Deprecated observer. Kept just as history
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $order = null;
        $orderIds = $observer->getDataByKey('order_ids');
        if ($this->shippingHelper->isEnabled() &&
            $this->shippingHelper->isEnabledCustomMapping() &&
            isset($orderIds)
        ) {
            $order = $this->orderRepository->get($orderIds[0]);
            $this->shippingHelper->setOrderCustomMappingInfo($order);
        }

        if ($this->shippingHelper->isEnabled() &&
            $this->shippingHelper->getShipmentsCreationMode() === Data::MBE_CREATION_MODE_AUTOMATICALLY
        ) {
            try {

                if ($order) {
                    //only if order is shipped with mbe and the shipment is still missing
                    if ($this->shippingHelper->isMbeShipping($order)
                        && $order->getShipmentsCollection()->count() === 0
                    ) {
                        $stateNew = \Magento\Sales\Model\Order::STATE_NEW;
                        $paymentMethod = $order->getPayment()->getMethodInstance()->getCode();

                        if ($order->getState() == $stateNew && $paymentMethod == "cashondelivery") {
                            $this->shippingLoggerHelper->log("NewOrderObserver - cashondelivery");

                            $this->eventManager->dispatch('mbe_sales_order_save_after', [
                                'order' => $observer->getDataByKey('order'),
                            ]);
                        }
                    }
                }
            } catch (\Exception $e) {
                $this->shippingLoggerHelper->log("NewOrderObserver - cashondelivery - cannot save shipment ");
                $this->shippingLoggerHelper->log($e->getMessage());
            }
        }
        return $this;
    }
}
