<?php

namespace Mbe\Shipping\Model\Adminhtml\System\Config\Backend\Shipping;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Filesystem;
use Mbe\Shipping\Helper\Csv;
use Mbe\Shipping\Helper\Data;

class CsvPackageProductToTable extends CsvFileToTable
{
    private $packagesCollectionFactory;

    public function __construct(
        \Magento\Framework\Model\Context                                           $context,
        \Magento\Framework\Registry                                                $registry,
        ScopeConfigInterface                                                       $config,
        \Magento\Framework\App\Cache\TypeListInterface                             $cacheTypeList,
        \Magento\MediaStorage\Model\File\UploaderFactory                           $uploaderFactory,
        \Magento\Config\Model\Config\Backend\File\RequestData\RequestDataInterface $requestData,
        \Magento\Framework\Message\ManagerInterface                                $messageManager,
        Filesystem                                                                 $filesystem,
        Data                                                                       $shippingHelper,
        Csv                                                                        $csvHelper,
        \Mbe\Shipping\Model\csvEntityModelFactory                                  $entityModelFactory,
        \Magento\Framework\Filesystem\Driver\File                                  $fileDriver,
        \Mbe\Shipping\Model\ResourceModel\Packages\CollectionFactory               $packagesCollectionFactory,
        \Magento\Framework\Model\ResourceModel\AbstractResource                    $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb                              $resourceCollection = null,
        array                                                                      $data = []
    ) {
        $this->csvEntityModelClass = \Mbe\Shipping\Model\PackagesProduct::class;
        parent::__construct($context, $registry, $config, $cacheTypeList, $uploaderFactory, $requestData, $messageManager, $filesystem, $shippingHelper, $csvHelper, $entityModelFactory, $fileDriver, $resource, $resourceCollection, $data);
        $this->packagesCollectionFactory = $packagesCollectionFactory;

        $this->csvHeaderDefinitions = [
            "package_code" => "package_code",
            "product_sku" => "product_sku",
            "single_parcel" => "single_parcel",
            "custom_package" => "custom_package"
        ];
    }

    /**
     * Check if a package that is marked as "custom" is used more than once
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function noDuplicateCustomPackageProduct($filePath)
    {
        try {
            $csvArray = $this->csvHelper->readFile($filePath, $this->csvHeaderDefinitions);
        } catch (LocalizedException $exception) {
            return $exception;
        }

        $customPackages = array_unique(array_column(array_filter(
            $csvArray,
            function ($v) {
                return $v['custom_package'] === '1';
            }
        ), 'package_code'));

        $multiplePackages = array_keys(array_diff(array_count_values(array_column($csvArray, 'package_code')), [1]));

        $invalidPackages = array_intersect($multiplePackages, $customPackages);
        if ($invalidPackages) {
            throw new \Magento\Framework\Exception\LocalizedException(
                __(__('Custom package used more than once:').json_encode($invalidPackages))
            );
        }
    }

    protected function _getValidationCallbacks()
    {
        return ['noduplicatepackprod' => 'noDuplicateCustomPackageProduct'];
    }

    public function afterSave()
    {
        // Check if the selected default package is still valid and update it if necessary
        if ($this->fileUpdated) {
            $defaultPackages = $this->packagesCollectionFactory->create()->getStandardPackages();
            if ($defaultPackages->count() > 0 && !in_array($this->shippingHelper->getCsvStandardPackageDefault(), $defaultPackages->getColumnValues('id'))) {
                $this->shippingHelper->setCsvStandardPackageDefault($defaultPackages->getFirstItem()->getData('id'));
            }
            /** TODO: forse non necessario perchè se non ci sono package ha già aggiornato la aftersave della CsvPackageToTable
            elseif ($defaultPackages->count() <= 0) {
                $this->shippingHelper->disableCsvStandardPackage();
            }
            */
        }
        return parent::afterSave();
    }
}
