<?php
namespace Mbe\Shipping\Block\Adminhtml\System\Config\Form\Field;

use Magento\Ui\Component\Form\Element\AbstractElement;

class CsvPackageDownload extends \Magento\Config\Block\System\Config\Form\Field
{

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Magento\Backend\Block\Template\Context $context,
        array $data = []
    ) {
        $this->shippingHelper = $shippingHelper;

        parent::__construct($context, $data);
    }

    protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $this->setElement($element);

        $buttonBlock = $this->getLayout()->createBlock(\Magento\Backend\Block\Widget\Button::class);

        $currentCsvPackagesUrl = $this->shippingHelper->getCurrentCsvPackagesUrl();
        $data = [
            'label'   => __('Download current file'),
            'onclick' => 'setLocation(\'' . $currentCsvPackagesUrl . '\' )',
            'class'   => $currentCsvPackagesUrl === ''?'disabled':'',
        ];
        $html = $buttonBlock->setData($data)->toHtml();

        $data = [
            'label'   => __('Download template file'),
            'onclick' => 'setLocation(\'' . $this->shippingHelper->getCsvTemplatePackagesUrl() . '\' )',
            'class'   => '',
        ];
        $html .= $buttonBlock->setData($data)->toHtml();

        $buttonBlock->setData($data)->toHtml();

        return $html;
    }

    /**
     * Remove scope label
     *
     * @param  AbstractElement $element
     * @return string
     */
    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }
}
