<?php
namespace Mbe\Shipping\Controller\Adminhtml\Shipments;

use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;

class ExportExcel extends \Magento\Backend\App\Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;

    protected $fileFactory;
    
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->fileFactory = $fileFactory;
        
        parent::__construct($context);
    }

    public function execute()
    {
        $resultPage = $this->resultPageFactory->create();
        
        $fileName = 'mbe_shipping.xml';
        $grid = $resultPage->getLayout()->createBlock('Mbe\Shipping\Block\Adminhtml\Sales\Shipment\Grid');
        return $this->fileFactory->create($fileName, $grid->getExcelFile($fileName), \Magento\Framework\App\Filesystem\DirectoryList::VAR_DIR);
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_Backend::content');
    }
}