<?php
namespace Mbe\Shipping\Controller\Adminhtml\Shipments;

use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;

class Index extends \Magento\Backend\App\Action
{

    /**
     * @var \Magento\Backend\Model\Auth\Session
     */
    protected $backendAuthSession;

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    /**
     * @var PageFactory
     */
    protected $resultPageFactory;
    
    public function __construct(
        \Magento\Backend\Model\Auth\Session $backendAuthSession,
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        Context $context,
        PageFactory $resultPageFactory
    ) {
        $this->backendAuthSession = $backendAuthSession;
        $this->shippingHelper = $shippingHelper;
        $this->shippingWsFactory = $shippingWsFactory;
        $this->resultPageFactory = $resultPageFactory;
        
        parent::__construct($context);
    }

    public function execute()
    {
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Mbe_Shipping::shipments');
        $resultPage->addBreadcrumb(__('MBE Shipments'), __('MBE Shipments'));
        $resultPage->addContent($resultPage->getLayout()->createBlock('Mbe\Shipping\Block\Adminhtml\Sales\Shipment'));
        $resultPage->getConfig()->getTitle()->prepend(__('MBE Shipments'));
        
        return $resultPage;
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_Backend::content');
    }
}