<?php
namespace Mbe\Shipping\Helper;

class BaseLogger
{
    protected $helper;
    protected $logger;
    protected $pluginVersion;

    public function __construct(
        \Psr\Log\LoggerInterface $logger,
        \Mbe\Shipping\Helper\Data $helper
    ) {
        $this->helper = $helper;
        $this->logger = $logger;
        $this->pluginVersion = 'version ' . $this->helper->getPluginVersion() . ' :';
    }

    public function log($message)
    {
        if ($this->helper->debug()) {
            $this->logger->debug($this->pluginVersion.$message);
        }
    }

    public function logVar($var, $message = null)
    {
        if ($this->helper->debug()) {
            if ($message) {
                $this->logger->debug($this->pluginVersion.$message);
            }
            $this->logger->debug(print_r($var, true));
        }
    }
}