<?php

namespace Mbe\Shipping\Model\Adminhtml\System\Config\Backend\Shipping;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Filesystem;
use Mbe\Shipping\Helper\Csv;
use Mbe\Shipping\Helper\Data;

class CsvPackageToTable extends CsvFileToTable
{
    private $packagesCollectionFactory;

    public function __construct(
        \Magento\Framework\Model\Context                                           $context,
        \Magento\Framework\Registry                                                $registry,
        ScopeConfigInterface                                                       $config,
        \Magento\Framework\App\Cache\TypeListInterface                             $cacheTypeList,
        \Magento\MediaStorage\Model\File\UploaderFactory                           $uploaderFactory,
        \Magento\Config\Model\Config\Backend\File\RequestData\RequestDataInterface $requestData,
        \Magento\Framework\Message\ManagerInterface                                $messageManager,
        Filesystem                                                                 $filesystem,
        Data                                                                       $shippingHelper,
        Csv                                                                        $csvHelper,
        \Mbe\Shipping\Model\csvEntityModelFactory                                  $entityModelFactory,
        \Magento\Framework\Filesystem\Driver\File                                  $fileDriver,
        \Mbe\Shipping\Model\ResourceModel\Packages\CollectionFactory               $packagesCollectionFactory,
        \Magento\Framework\Model\ResourceModel\AbstractResource                    $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb                              $resourceCollection = null,
        array                                                                      $data = []
    ) {
        $this->csvEntityModelClass = \Mbe\Shipping\Model\Packages::class;
        parent::__construct($context, $registry, $config, $cacheTypeList, $uploaderFactory, $requestData, $messageManager, $filesystem, $shippingHelper, $csvHelper, $entityModelFactory, $fileDriver, $resource, $resourceCollection, $data);
        $this->packagesCollectionFactory = $packagesCollectionFactory;

        $this->csvHeaderDefinitions = [
            "package_code" => "package_code",
            "package_label" => "package_label",
            "height" => "height",
            "width" => "width",
            "length" => "length",
            "max_weight" => "max_weight"
        ];
    }

    /**
     * @throws LocalizedException
     */
    public function useReservedCode($filePath)
    {
        try {
            $csvArray = $this->csvHelper->readFile($filePath, $this->csvHeaderDefinitions);
        } catch (LocalizedException $exception) {
            return $exception;
        }

        $reservedCode = Data::MBE_CSV_PACKAGES_RESERVED_CODE;
        $haystack = array_column($csvArray, 'package_code');

        if (array_search($reservedCode, $haystack) !== false) {
            throw new LocalizedException(
                __(__('Reserved package code cannot be used:') . $reservedCode)
            );
        }
    }

    protected function _getValidationCallbacks()
    {
        return ['reservedname' => 'useReservedCode'];
    }

    public function afterSave()
    {
        // If the packages list is new,set the first value as default or disable the csvPackage if there are no packages
        if ($this->fileUpdated) {
            $defaultPackages = $this->packagesCollectionFactory->create()->getStandardPackages();
            if ($defaultPackages->count() > 0) {
                $this->shippingHelper->setCsvStandardPackageDefault($defaultPackages->getFirstItem()->getData('id'));
            } else {
                // Check done also in Mbe\Shipping\Observer\AdminSettingObserver. Kept to be sure it will be disabled
                $this->shippingHelper->disableCsvStandardPackage();
            }
        }
        return parent::afterSave();
    }

}
