<?php

namespace Mbe\Shipping\Model;

use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\App\Helper\Context;
use Mbe\Shipping\Model\PackagesFactory;

class CsvEntityModelFactory
{
    protected $context;
    protected $messageManager;
    protected $packagesModelFactory;
    protected $packagesProductModelFactory;
//    protected $packagesResourceModelFactory;
//    protected $packagesProductResourceModelFactory;

    public function __construct(
        Context                                                  $context,
        ManagerInterface                                         $messageManager,
        \Mbe\Shipping\Model\PackagesFactory                      $packagesModelFactory,
//        \Mbe\Shipping\Model\ResourceModel\PackagesFactory        $packagesResourceModelFactory,
        \Mbe\Shipping\Model\PackagesProductFactory               $packagesProductModelFactory
//        \Mbe\Shipping\Model\ResourceModel\PackagesProductFactory $packagesProductResourceModelFactory
    ) {
        $this->context = $context;
        $this->messageManager = $messageManager;
        $this->packagesModelFactory = $packagesModelFactory;
//        $this->packagesResourceModelFactory = $packagesResourceModelFactory;
        $this->packagesProductModelFactory = $packagesProductModelFactory;
//        $this->packagesProductResourceModelFactory = $packagesProductResourceModelFactory;
    }

    public function create($entityHelperClass)
    {
        switch ($entityHelperClass) {
            case Packages::class:
                return $this->packagesModelFactory->create();
            case PackagesProduct::class:
                return $this->packagesProductModelFactory->create();
        }
    }
}
