<?php

namespace Mbe\Shipping\Model;

use Magento\Framework\Exception\AlreadyExistsException;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\Model\AbstractModel;
use Mbe\Shipping\Helper\Data;
use Mbe\Shipping\Helper\Logger;
use Mbe\Shipping\Model\ResourceModel\MbeQuote as ResourceModel;

class MbeQuote extends AbstractModel
{
    /**
     * @var string
     */
    protected $_eventPrefix = 'mbe_quote_model';
    protected $logger;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry      $registry,
        ManagerInterface                 $messageManager,
        ResourceModel                    $mbeQuoteResourceModel,
        Logger                           $logger
    )
    {
        $this->mbeQuoteResourceModel = $mbeQuoteResourceModel;
        $this->messageManager = $messageManager;
        $this->logger = $logger;
        parent::__construct($context, $registry);
    }

    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    public function insertRow($row)
    {
        $insertResult = $this->addData($row);
        try {
            $this->mbeQuoteResourceModel->save($insertResult);
        } catch (AlreadyExistsException $e) {
            $message = __('Row already exist in table:') . json_encode($row);
            $this->messageManager->addErrorMessage($message);
            $this->logger->log($message);
            return false;
        } catch (\Exception $e) {
            $message = __('Unexpected error') . ': ' . $e->getMessage();
            $this->messageManager->addErrorMessage($message);
            $this->logger->log($message);
        }
        $this->unsetData();
        return true;
    }
}
