<?php
namespace Mbe\Shipping\Model\Source;


class ShipmentTypes
{

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    public function __construct(
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory
    ) {
        $this->shippingWsFactory = $shippingWsFactory;
    }
    public function toOptionArray()
    {
        $result = array(
            array('value' => 'GENERIC', 'label' => __('GENERIC')),

        );

        /**
         * @var $ws Mbe_Shipping_Model_Ws
         */

        $ws = $this->shippingWsFactory->create();
        $customer = $ws->customer;

        /*
         * 1. se <canChooseMBEShipType> = TRUE, nella configurazione il gestore potrà scegliere il default tra GENERIC (il pacco normale) e ENVELOPE (la busta, fino a 2.5kg)
         *  2. se <canChooseMBEShipType> = FALSE, per il momento farei che di default è GENERIC
         */
        if ($customer && $customer->Permissions->canChooseMBEShipType) {
            array_push($result, array('value' => 'ENVELOPE', 'label' => __('ENVELOPE')));
        }

        return $result;
    }

}