<?php

namespace Mbe\Shipping\Observer;

use Magento\Framework\Event\ObserverInterface;
use Mbe\Shipping\Helper\Data;
use Mbe\Shipping\Helper\Logger;

class AddMailVariabletrackingNumber implements ObserverInterface
{

    /**
     * @var Data
     */
    protected $helper;
    protected $trackingHelper;
    protected $logger;

    public function __construct(
        Data                          $helper,
        \Mbe\Shipping\Helper\Tracking $trackingHelper,
        Logger                        $logger
    ) {
        $this->helper = $helper;
        $this->trackingHelper = $trackingHelper;
        $this->logger = $logger;
    }

    /**
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if ($this->helper->isEnabled()) {
            $transport = $observer->getData('transportObject');
            $track_ids = '';
            if (!empty($transport->getOrder())) {
                foreach ($transport->getOrder()->getTracksCollection() as $item) {
                    $track_ids .= '<br><a href="' .
                        $this->trackingHelper->getTrackingUrlBySystem($this->helper->getCountry()) .
                        $item->getTrackNumber() .
                        '">' .
                        $item->getTrackNumber() . '</a>';
                }
                $transport->setMbeTrackid((!empty($track_ids) ? ('<br>' . __('MBE Tracking :')) : '') . $track_ids);
            } else {
                $this->logger->log('MBE Tracking Variable - Cannot add variable to messages, order not found');
            }
        }
    }
}
