<?php

namespace Mbe\Shipping\Observer;

use Magento\Framework\App\Cache\Frontend\Pool;
use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Sales\Model\Order\Shipment\NotifierInterface;
use Magento\Sales\Model\Order\Shipment\TrackRepository;
use Magento\Sales\Model\Order\ShipmentRepository;
use Magento\Shipping\Model\Shipping\LabelGenerator;
use Mbe\Shipping\Classes\MbeWs;
use Mbe\Shipping\Helper\Data;

class AdminSettingObserver extends \Mbe\Shipping\Model\Observer
{
    protected $resourceConfig;
    protected $shippingHelper;
    protected $dir;
    protected $mbeWs;
    protected $serializer;
    protected $shippingLoggerHelper;
    protected $cacheTypeList;
    protected $cacheFrontendPool;

    private $standardPackagesFactory;

    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Helper\Logger $shippingLoggerHelper,
        \Magento\Sales\Model\OrderFactory $salesOrderFactory,
        \Magento\Framework\DB\TransactionFactory $transactionFactory,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        \Magento\Sales\Model\Order\Shipment\TrackFactory $salesOrderShipmentTrackFactory,
        \Magento\Framework\Stdlib\DateTime\DateTimeFactory $dateTimeDateTimeFactory,
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $salesResourceModelOrderCollectionFactory,
        \Magento\Framework\ObjectManagerInterface $objectManager,
        \Magento\Config\Model\ResourceModel\Config $resourceConfig,
        \Magento\Framework\Filesystem\DirectoryList $dir,
        \Magento\Framework\HTTP\PhpEnvironment\Request $request,
        SerializerInterface $serializer,
        TypeListInterface $cacheTypeList,
        Pool $cacheFrontendPool,
        NotifierInterface $notifier,
        ShipmentRepository $shipmentRepository,
        TrackRepository $trackRepository,
        LabelGenerator $labelGenerator,
        \Mbe\Shipping\Model\ResourceModel\Packages\CollectionFactory        $standardPackagesFactory,
        MbeWs $mbeWs
    ) {
        parent::__construct($shippingHelper, $shippingLoggerHelper, $salesOrderFactory, $transactionFactory, $shippingWsFactory, $salesOrderShipmentTrackFactory, $dateTimeDateTimeFactory, $salesResourceModelOrderCollectionFactory, $objectManager, $request, $notifier, $shipmentRepository, $trackRepository, $labelGenerator);
        $this->resourceConfig = $resourceConfig;
        $this->shippingHelper = $shippingHelper;
        $this->dir = $dir;
        $this->shippingLoggerHelper = $shippingLoggerHelper;
        $this->serializer = $serializer;
        $this->cacheTypeList = $cacheTypeList;
        $this->cacheFrontendPool = $cacheFrontendPool;
        $this->standardPackagesFactory = $standardPackagesFactory;
        $this->mbeWs = $mbeWs;
    }

    public function execute(Observer $observer)
    {
        if ($this->shippingHelper->isEnabled()) {
            $this->setMbeSettingsCache();
//            $this->setMbeShipToUapValue();
            $this->checkcsvStandarPackageSetting();
        }
    }

    protected function checkcsvStandarPackageSetting()
    {
        if ($this->standardPackagesFactory->create()->count() <= 0
            || \Mbe\Shipping\Model\Carrier::SHIPMENT_CONFIGURATION_MODE_ONE_SHIPMENT_PER_SHOPPING_CART_WEIGHT_MULTI_PARCEL != $this->shippingHelper->getShipmentConfigurationMode()
        ) {
            $this->shippingHelper->disableCsvStandardPackage();
        }
    }

//    protected function setMbeShipToUapValue()
//    {
//        $ws = $this->shippingWsFactory->create();
//        $enabledCourierServices = $ws->getCustomerPermission('enabledCourierServices');
//        $enabledShipUAP = $ws->getCustomerPermission('enabledShipUAP');
//
//        // Check if UAP Option should be available
//        if (!(in_array('UST', (explode(',', $enabledCourierServices)??[])) !== false
//            && in_array('SSE', (explode(',', $this->shippingHelper->getAllowedShipmentServices())??[])) !== false
//            && $enabledShipUAP)
//        ) {
//            // set mbe_ship_to_UAP to false
//            $this->resourceConfig->saveConfig(Data::XML_PATH_SHIP_TO_UAP, 0, 'default');
//        }
//    }

    protected function setMbeSettingsCache()
    {
        $wsUrl = $this->shippingHelper->getWsUrl()??'empty';
        $wsUsername = $this->shippingHelper->getWsUsername()??'empty';
        $wsPassword = $this->shippingHelper->getWsPassword()??'empty';
        $system = $this->shippingHelper->getCountry()??'empty';

//        if ($wsUrl && $wsUsername && $wsPassword) {
        $customerData = $this->mbeWs->getCustomer($wsUrl, $wsUsername, $wsPassword, $system);
        $this->shippingLoggerHelper->logVar($customerData, 'WS getCustomer');
        $this->resourceConfig->saveConfig(
            Data::XML_PATH_CACHEDCUSTOMERDATA,
            $this->serializer->serialize($customerData)
        );
        $this->flushCache();

//        }
    }
    public function flushCache()
    {
        $this->cacheTypeList->cleanType('config');

        foreach ($this->cacheFrontendPool as $cacheFrontend) {
            $cacheFrontend->getBackend()->clean();
        }
    }

}