<?php

namespace Mbe\Shipping\Plugin\Model;

use Magento\Checkout\Model\ShippingInformationManagement;
use Magento\Checkout\Api\Data\ShippingInformationInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Mbe\Shipping\Helper\Data;

/**
 * Update the shipping address using the selected UAP
 * Class ShippingInformationManagementPlugin
 */
class ShippingInformationManagementPlugin
{
    protected $shippingHelper;
    protected $quoteRepository;

    public function __construct(
        Data $shippingHelper,
        CartRepositoryInterface $quoteRepository
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->quoteRepository = $quoteRepository;
    }

    public function beforeSaveAddressInformation(
        ShippingInformationManagement $subject,
                                      $cartId,
        ShippingInformationInterface $addressInformation
    ) {
        if ($this->shippingHelper->isEnabled()) {
            $mbe_uap_address = json_decode(stripslashes($addressInformation->getExtensionAttributes()->getMbeShippingUapShipment()??''));
            $quote = $this->quoteRepository->getActive($cartId);
            // set quote custom field
            $quote->setExtensionAttributes($quote->getExtensionAttributes()->setmbeShippingUapShipment($mbe_uap_address->PublicAccesPointID??null));
            $this->quoteRepository->save($quote);
            if (!empty($mbe_uap_address)) {
                // SET THE ADDRESS VALUES TO BE SURE THEY MATCH UAP ONES
                $shippingAddress = $addressInformation->getShippingAddress();
                // set empty values
                $shippingAddress->setCustomerAddressId(null);
                $shippingAddress->setRegionCode(null);
                $shippingAddress->setFax(null);

                // do not add it to the address book, if not set in frontend
                if ($shippingAddress->getsetSaveInAddressBook() === null) {
                    $shippingAddress->setSaveInAddressBook(false);
                }
                // do not set same as billing, if not set in frontend
                if ($shippingAddress->getsetSameAsBilling() === null) {
                    $shippingAddress->setSameAsBilling(false);
                    $addressInformation->getBillingAddress()->setSameAsBilling(false);
                }

                // set the data to be sure we are using the billing ones
//                $shippingAddress->setTelephone($addressInformation->getBillingAddress()->getTelephone());
//                $shippingAddress->setFirstname($addressInformation->getBillingAddress()->getFirstname());
//                $shippingAddress->setLastname($addressInformation->getBillingAddress()->getLastname());

                // Set the address values
                $shippingAddress->setCountryId($mbe_uap_address->CountryCode);
                $shippingAddress->setCompany($mbe_uap_address->ConsigneeName);
                $shippingAddress->setStreet($mbe_uap_address->AddressLine);
                $shippingAddress->setCity($mbe_uap_address->PoliticalDivision2);
                $shippingAddress->setPostcode($mbe_uap_address->PostcodePrimaryLow);
                if(!empty($mbe_uap_address->PoliticalDivision1)) {
                    $shippingAddress->setRegion($mbe_uap_address->PoliticalDivision1);
                }
                $addressInformation->setShippingAddress($shippingAddress);

                return [$cartId, $addressInformation];
            }
        }
        return null;
    }

}