<?php
namespace Mbe\Shipping\Classes;

class MbeSoapClient extends \SoapClient
{

    public $isOnlinembe = false;

    public function __construct($wsdl, array $options = null, $username = null, $password = null, $wsdlcache = true)
    {
        if (strpos(strtolower($wsdl), 'onlinembe') !== false) {
            $this->isOnlinembe = true;
            parent::__construct($wsdl, $options);
        } else {
            $opts = [
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                ],
                'http' => [
                    'protocol_version' => 1.0
                ]
            ];
            $context = stream_context_create($opts);

            $soapClientOptions = [
                'trace' => 1,
                'stream_context' => $context,
                'login' => $username,
                'password' => $password,
                'location' =>  preg_replace('/(\/e-link\.wsdl)$/i', '', $wsdl),
                'cache_wsdl' => $wsdlcache?WSDL_CACHE_MEMORY:WSDL_CACHE_NONE,
            ];

            parent::__construct($wsdl, $soapClientOptions);
        }
    }

    #[\ReturnTypeWillChange]
    public function __soapCall($function_name, $arguments, $options = null, $input_headers = null, &$output_headers = null)
    {
        if (!$this->isOnlinembe) {
            $arguments[0]->RequestContainer->Credentials->Username = '';
            $arguments[0]->RequestContainer->Credentials->Passphrase = '';
        }
        return parent::__soapCall($function_name, $arguments, $options, $input_headers, $output_headers);
    }


}