<?php
namespace Mbe\Shipping\Controller\Adminhtml\Shipments;

use Magento\Backend\App\Action\Context;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;
use Magento\Ui\Component\MassAction\Filter;
use Mbe\Shipping\Helper\Data;
use Psr\Log\LoggerInterface;

class MassCreateShipments extends \Magento\Backend\App\Action
{
    protected $helper;
    protected $orderRepository;
    protected $logger;
    protected $filter;
    protected $orderCollectionFactory;
    protected $responseFactory;
    protected $url;

    public function __construct(
        Context $context,
        OrderRepositoryInterface $orderRepository,
        CollectionFactory $orderCollectionFactory,
        Filter $filter,
        Data $helper,
        LoggerInterface $logger
    ) {
        $this->helper = $helper;
        $this->orderRepository = $orderRepository;
        $this->filter = $filter;
        $this->logger = $logger;
        $this->orderCollectionFactory = $orderCollectionFactory;

        parent::__construct($context);
    }

    public function execute()
    {
        if ($this->helper->isEnabled()) {
            $createdCount = 0;
            $orders = $this->filter->getCollection($this->orderCollectionFactory->create());
            foreach ($orders as $order) {
                if ($this->helper->isMbeShipping($order) && empty($order->getShipmentsCollection()->count())) {
                    try {
                        if ($order->canShip()) { // check this just to speed up the process
                            // load the order instance to access all the data
                            $order = $this->orderRepository->get($order->getId());
                            $this->_eventManager->dispatch('mbe_sales_order_shipment_create', ['order' => $order]);
                            // check if the shipment has been created
                            if ($order->getShipmentsCollection()->count()>0) {
                                $createdCount++;
                            }
                        }
                    } catch (\Exception $e) {
                        $this->logger->error($e);
                    }
                }
            }
            $this->messageManager->addSuccessMessage(__('Shipments created:').' '.$createdCount);
        }

        $this->_redirect('sales/order/index');
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_Backend::content');
    }
}