<?php

namespace Mbe\Shipping\Model;

use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\Exception\AlreadyExistsException;
use Magento\Framework\Exception\LocalizedException;

class Packages extends \Magento\Framework\Model\AbstractModel implements
    \Magento\Framework\DataObject\IdentityInterface,
    CsvEntityModelInterface
{
    const CACHE_TAG = 'mbe_shipping_standard_packages';
    protected $_cacheTag = 'mbe_shipping_standard_packages';
    protected $_eventPrefix = 'mbe_shipping_standard_packages';

    protected $mainTableName;
    protected $packagesResourceModel;
    protected $messageManager;

    public function __construct(
        \Magento\Framework\Model\Context                  $context,
        \Magento\Framework\Registry                       $registry,
        ManagerInterface                                  $messageManager,
        \Mbe\Shipping\Model\ResourceModel\PackagesFactory $packagesResourceModelFactory
    ) {
        $this->packagesResourceModel = $packagesResourceModelFactory->create();
        $this->messageManager = $messageManager;
        try {
            $this->mainTableName = $this->packagesResourceModel->getMainTable();
        } catch (LocalizedException $e) {
            $this->messageManager->addErrorMessage(__('Main table not set for ') . self::class);
            return $e;
        }
        parent::__construct($context, $registry);
    }

    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    public function getDefaultValues()
    {
        $values = [];
        return $values;
    }

    public function truncate()
    {
        try {
            $this->packagesResourceModel->getConnection()->delete($this->mainTableName);
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Error while truncating table ') . $this->mainTableName . ' :' . $e->getMessage());
            return false;
        }
        return true;
    }

    public function insertRow($row)
    {
        $insertResult = $this->addData($row);
        try {
            $this->packagesResourceModel->save($insertResult);
        } catch (AlreadyExistsException $e) {
            $this->messageManager->addErrorMessage(__('Row already exist in table:').json_encode($row));
            return false;
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Unexpected error') . ': ' . $e->getMessage());
        }
        $this->unsetData();
        return true;
    }

    protected function _construct()
    {
        $this->_init(ResourceModel\Packages::class);
    }
}
