<?php

namespace Mbe\Shipping\Plugin\Controller\Adminhtml\Order\Invoice;

use Magento\Framework\EntityManager\EventManager;
use Magento\Framework\ObjectManagerInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Mbe\Shipping\Helper\Data;

class SavePlugin
{
    protected $shippingHelper;
    protected $eventManager;
    protected $objectManager;
    protected $orderRepository;
    protected $invoiceShip = false;

    public function __construct(
        Data $shippingHelper,
        EventManager $eventManager,
        OrderRepositoryInterface $orderRepository,
        ObjectManagerInterface $objectManager
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->eventManager = $eventManager;
        $this->objectManager = $objectManager;
        $this->orderRepository = $orderRepository;
    }

    public function beforeExecute(\Magento\Sales\Controller\Adminhtml\Order\Invoice\Save $subject)
    {
        if ($this->shippingHelper->isEnabled()) {
            $invoice = $subject->getRequest()->getParam('invoice');
            $order = $this->orderRepository->get($subject->getRequest()->getParam('order_id'));
            if (isset($invoice['do_shipment']) && $this->shippingHelper->isMbeShipping($order)) {
                $invoice['do_shipment'] = 0; // override the magento shipment creation option
                $this->invoiceShip = true;
                $subject->getRequest()->setPostValue('invoice', $invoice);
            }
        }
        return null;
    }

    public function afterExecute(\Magento\Sales\Controller\Adminhtml\Order\Invoice\Save $subject, $result)
    {
        // Create a MBE shipment if the before method has been executed sucessfully and the creation mode is MANUAL
        // If AUTOMATIC mode is set, shipment will be created on sales_order_save_after
        if ($this->shippingHelper->isEnabled()
            && $this->invoiceShip
            && $this->shippingHelper->getShipmentsCreationMode() === Data::MBE_CREATION_MODE_MANUALLY
        ) {
            $order = $this->orderRepository->get($subject->getRequest()->getParam('order_id'));
            $this->eventManager->dispatch('mbe_sales_order_shipment_save', [
                'order' => $order,
                'invoiceShip' => true,
                'mbeShipment' => true
            ]);
        }
        return $result;
    }
}