<?php

namespace Mbe\Shipping\Plugin\Model;

use \Magento\Sales\Api\OrderRepositoryInterface;
use \Magento\Sales\Api\Data\OrderInterface;
use Mbe\Shipping\Helper\Data;
use Mbe\Shipping\Model\ResourceModel\MbeSalesOrder\CollectionFactory as MbeSalesOrderCollectionFactory;

class OrderRepositoryPlugin
{
    protected $mbeSalesOrderCollectionFactory;
    protected $mbeSalesOrderModelFactory;
    protected $shippinghelper;

    public function __construct(
        MbeSalesOrderCollectionFactory          $mbeSalesOrderCollectionFactory,
        \Mbe\Shipping\Model\MbeSalesOrderFactory $mbeSalesOrderModelFactory,
        Data $shippinghelper
    )
    {
        $this->mbeSalesOrderCollectionFactory = $mbeSalesOrderCollectionFactory;
        $this->mbeSalesOrderModelFactory = $mbeSalesOrderModelFactory;
        $this->shippinghelper = $shippinghelper;
    }

    public function afterGet(
       OrderRepositoryInterface $subject,
       OrderInterface $resultOrder
    ) {
        $resultOrder = $this->getMbeAttributes($resultOrder);

        return $resultOrder;
    }

    public function afterSave(
        OrderRepositoryInterface $subject,
        OrderInterface $resultOrder
    ) {
        $resultOrder = $this->setMbeAttribute($resultOrder,'mbe_shipping_uap_shipment');
        $resultOrder = $this->setMbeAttribute($resultOrder, 'is_mbe_custom_mapping');

        return $resultOrder;
    }

    public function afterGetList(
        OrderRepositoryInterface $subject,
        \Magento\Sales\Api\Data\OrderSearchResultInterface $resultOrder
    ) {
        /** @var  $order */
        foreach ($resultOrder->getItems() as $order) {
            $this->afterGet($subject, $order);
        }
        return $resultOrder;
    }
    private function setMbeAttribute(OrderInterface $order, $attribute)
    {
        $extensionAttributes = $order->getExtensionAttributes();
        $getAttribute = 'get'.$this->shippinghelper->strToCamelCase($attribute,'_', true);

        if (
            null !== $extensionAttributes &&
            null !== $extensionAttributes->$getAttribute()
        ) {
            $extensionAttributeValue = $extensionAttributes->$getAttribute();
//            $MbeIsCustomMapping = $extensionAttributes->getIsMbeCustomMapping();
            try {
                $mbeSalesOrderCollection = $this->mbeSalesOrderCollectionFactory->create();
                $mbeSalesOrder = $mbeSalesOrderCollection->addFieldToFilter('order_id', $order->getEntityId())
                    ->getFirstItem();
                if (!$mbeSalesOrder->hasData()) {
                    $insertResult = $this->mbeSalesOrderModelFactory->create()->insertRow(
                        [
                            $attribute => $extensionAttributeValue,
                            "order_id" => $order->getEntityId()
                        ]
                    );
                    if (!$insertResult) {
                        $this->messageManager->addErrorMessage(__('Error inserting mbe extension attributes for the order'));
                        return false;
                    }
                } else {
                    $mbeSalesOrder->setData($attribute, $extensionAttributeValue)->save();
//                    $mbeSalesOrder->setData('is_mbe_custom_mapping', $MbeShippingUapShipmentValue);
                }
            } catch (\Exception $e) {
                throw new CouldNotSaveException(
                    __('Could not add attribute to order: "%1"', $e->getMessage()),
                    $e
                );
            }
        }
        return $order;
    }

    private function getMbeAttributes(OrderInterface $order)
    {

        try {
            $mbeSalesOrder = $this->mbeSalesOrderCollectionFactory
                ->create()
                ->addFieldToFilter('order_id', $order->getEntityId())
                ->getFirstItem();
        } catch (NoSuchEntityException $e) {
            return $order;
        }

        $extensionAttributes = $order->getExtensionAttributes();
        $extensionAttributes->setMbeShippingUapShipment($mbeSalesOrder->getData('mbe_shipping_uap_shipment'));
        $extensionAttributes->setIsMbeCustomMapping($mbeSalesOrder->getData('is_mbe_custom_mapping'));

        $order->setExtensionAttributes($extensionAttributes);

        return $order;
    }

}