define([
    'jquery',
    'uiComponent',
    'ko',
    'Magento_Checkout/js/model/quote',
    'mage/url',
], function ($, Component, ko, quote, urlBuilder) {
    'use strict';
    var self
    var checkShipment = ko.observable(false);

    return Component.extend({
        defaults: {
            template: 'Mbe_Shipping/mbe-uap-list-wrapper',
            exports:{
                disableSelectList: 'checkout.steps.shipping-step.shippingAddress.shippingAdditional.mbe-uap-list-wrapper.shipping-option.select-uap:disabled'
            }
        },

        initObservable: function () {
            self = this._super()
            var uapmethod = 'MDP' //Default value

            $.ajax({
                url: urlBuilder.build('mbe/uap/getuapmethod'),
                type: 'get',
                dataType: 'json',
            })
                .done(function(result){
                    console.log('uap method - '+result)
                    uapmethod = result
                })
                .fail(function () {
                    console.log('fail uap method')
                })

            self.checkMethod = ko.computed(function () {
                var method = quote.shippingMethod();

                if (method && method['carrier_code'] !== undefined) {
                    if (method['method_code'].search(uapmethod) !== -1
                        && method['carrier_code'] === 'mbe_shipping'
                    ) {
                        return true;
                    }
                }
                return false;
            }, this);

            this.showAdditionalOption = ko.pureComputed(function () {
                return !!(self.checkMethod());
            })

            this.disableSelectList = ko.pureComputed(function () {
                return !this.showAdditionalOption()
            }, this)

            return this;
        }
    });
});