<?php

namespace Mbe\Shipping\Block\Adminhtml\System\Config\Form\Field;

class UapSelector extends \Magento\Config\Block\System\Config\Form\Field
{
    protected $shippingWsFactory;
    protected $shippingHelper;

    public function __construct(
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        \Magento\Backend\Block\Template\Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->shippingHelper = $shippingHelper;
        $this->shippingWsFactory = $shippingWsFactory;
    }

    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $ws = $this->shippingWsFactory->create();
        $enabledCourierServices = $ws->getCustomerPermission('enabledCourierServices');
        $enabledShipUAP = $ws->getCustomerPermission('enabledShipUAP');

        // Check if UAP Option should be shown
        if (in_array('UST', (explode(',', $enabledCourierServices)??[])) !== false
            && in_array('SSE', (explode(',', $this->shippingHelper->getAllowedShipmentServices())??[])) !== false
            && $enabledShipUAP
        ) {
            return parent::render($element);
        }
        return false;
    }
}
