<?php
namespace Mbe\Shipping\Helper;

// Compatibility with new CsvToFile
// use Mbe\Shipping\Model\CsvEntityModelInterface;

class Rates extends \Magento\Framework\App\Helper\AbstractHelper
    // Compatibility with new CsvToFile
    // implements CsvEntityModelInterface
{
    protected $_rate_table_name = 'mbeshippingrate';

    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $resourceConnection;

    protected $shippingHelper;

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    public function __construct(
        \Magento\Framework\App\Helper\Context     $context,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \Mbe\Shipping\Helper\Data                 $shippingHelper,
        \Mbe\Shipping\Model\WsFactory             $shippingWsFactory
    ) {
        $this->shippingHelper = $shippingHelper;
        $this->shippingWsFactory = $shippingWsFactory;
        $this->resourceConnection = $resourceConnection;
        parent::__construct($context);
    }

    public function truncate()
    {
        $tableName = $this->resourceConnection->getTableName($this->_rate_table_name);

        $truncateSql = "DELETE FROM `" . $tableName . "` ";
        $write = $this->resourceConnection->getConnection("core_write");

        $truncateResult = $write->query($truncateSql);

        // dd($truncateResult);
        return $truncateResult;
    }

    public function insertRate($country, $region, $city, $zip, $zipTo, $weightFrom, $weightTo, $price, $deliveryType)
    {
        $tableName = $this->resourceConnection->getTableName($this->_rate_table_name);

        $write = $this->resourceConnection->getConnection("core_write");

        $insertResult = $write->insert(
            $tableName,
            array(
                "country"       => $country,
                "region"        => $region,
                "city"          => $city,
                "zip"           => $zip,
                "zip_to"        => $zipTo,
                "weight_from"   => $weightFrom,
                "weight_to"     => $weightTo,
                "price"         => $price,
                "delivery_type" => $deliveryType,
            )
        );
        return $insertResult;
    }


    public function useCustomRates($country)
    {
        $readConnection = $this->resourceConnection->getConnection('core_read');
        $tableName = $this->resourceConnection->getTableName($this->_rate_table_name);
        $result = false;

        if ($this->shippingHelper->getShipmentsCsvMode() == \Mbe\Shipping\Helper\Data::MBE_CSV_MODE_DISABLED) {
        }
        elseif ($this->shippingHelper->getShipmentsCsvMode() == \Mbe\Shipping\Helper\Data::MBE_CSV_MODE_TOTAL) {
            $result = true;
        }
        elseif ($this->shippingHelper->getShipmentsCsvMode() == \Mbe\Shipping\Helper\Data::MBE_CSV_MODE_PARTIAL) {
            $sql = "SELECT * FROM `" . $tableName . "` WHERE `country` = '" . $country . "'";
            $rates = $readConnection->fetchAll($sql);

            if (is_array($rates) && count($rates) > 0) {
                $result = true;
            }
        }
        return $result;
    }

    public function applyInsuranceToRate($rate, $insuranceValue)
    {
        $result = $rate;

        $this->shippingHelper->getShipmentsCsvInsurancePercentage();

        $percentageValue = $this->shippingHelper->getShipmentsCsvInsurancePercentage() / 100 * $insuranceValue;
        $fixedValue = $this->shippingHelper->getShipmentsCsvInsuranceMin();

        if ($percentageValue < $fixedValue) {
            $result += $fixedValue;
        }
        else {
            $result += $percentageValue;
        }
        return $result;
    }


    public function getCustomRates($country, $region, $city, $postCode, $weight, $insuranceValue)
    {
        $weight = $this->shippingHelper->convertWeight($weight);

        $result = array();
        $newdata = array();
        $zipSql = " '" . $postCode . "' BETWEEN zip AND zip_to";

        $services = $this->shippingHelper->getAllowedShipmentServicesArray();
        $tableName = $this->resourceConnection->getTableName($this->_rate_table_name);
        foreach ($services as $service) {

            for ($j = 0; $j <= 7; $j++) {

                $sql = "SELECT * FROM `" . $tableName . "` ";

                switch ($j) {
                    case 0:
                        $sql .= "WHERE ";
                        $sql .= "`country` = '" . $country . "'";
                        $sql .= " AND ";
                        $sql .= "`region` = '" . $region . "'";
                        $sql .= " AND ";
                        $sql .= " STRCMP(LOWER(city),LOWER('" . $city . "')) = 0";
                        $sql .= " AND ";
                        $sql .= $zipSql;

                        break;

                    case 1:
                        $sql .= "WHERE ";
                        $sql .= "`country` = '" . $country . "'";
                        $sql .= " AND ";
                        $sql .= "`region` = '" . $region . "'";
                        $sql .= " AND ";
                        $sql .= "`city` = ''";
                        $sql .= " AND ";
                        $sql .= $zipSql;

                        break;
                    case 2:
                        $sql .= "WHERE ";
                        $sql .= "`country` = '" . $country . "'";
                        $sql .= " AND ";
                        $sql .= "`region` = '" . $region . "'";
                        $sql .= " AND ";
                        $sql .= "STRCMP(LOWER(city),LOWER('" . $city . "')) = 0";
                        $sql .= " AND ";
                        $sql .= " zip = '' ";

                        break;
                    case 3:
                        $sql .= "WHERE ";
                        $sql .= "`country` = '" . $country . "'";
                        $sql .= " AND ";
                        //$sql .= "`region` = '" . $region . "'";
                        $sql .= "`region` = ''";
                        $sql .= " AND ";
                        $sql .= "STRCMP(LOWER(city),LOWER('" . $city . "')) = 0";
                        $sql .= " AND ";
                        $sql .= $zipSql;

                        break;
                    case 4:
                        $sql .= "WHERE ";
                        $sql .= "`country` = '" . $country . "'";
                        $sql .= " AND ";
                        //$sql .= "`region` = '" . $region . "'";
                        $sql .= "`region` = ''";
                        $sql .= " AND ";
                        $sql .= "STRCMP(LOWER(city),LOWER('" . $city . "')) = 0";
                        $sql .= " AND ";
                        $sql .= "zip = ''";

                        break;
                    case 5:
                        $sql .= "WHERE ";
                        $sql .= "`country` = '" . $country . "'";
                        $sql .= " AND ";
                        //$sql .= "`region` = '" . $region . "'";
                        $sql .= "`region` = ''";
                        $sql .= " AND ";
                        $sql .= "city = ''";
                        $sql .= " AND ";
                        $sql .= $zipSql;

                        break;
                    case 6:
                        $sql .= "WHERE ";
                        $sql .= "`country` = '" . $country . "'";
                        $sql .= " AND ";
                        $sql .= "`region` = '" . $region . "'";
                        $sql .= " AND ";
                        $sql .= "city = ''";
                        $sql .= " AND ";
                        $sql .= "zip = ''";
                        break;
                    case 7:
                        $sql .= "WHERE ";
                        $sql .= "`country` = '" . $country . "'";
                        $sql .= " AND ";
                        $sql .= "`region` = ''";
                        $sql .= " AND ";
                        $sql .= "city = ''";
                        $sql .= " AND ";
                        $sql .= "zip = ''";
                        break;

                }
                $sql .= " AND weight_from <= " . $weight . " AND weight_to >=" . $weight;
                $sql .= " AND delivery_type = '" . $service . "'";

                $sql .= " ORDER BY country DESC, region DESC, zip DESC";

                $readConnection = $this->resourceConnection->getConnection('core_read');
                $rows = $readConnection->fetchAll($sql, 'ARRAY_A');

                if (!empty($rows)) {
                    // have found a result or found nothing and at end of list!
                    foreach ($rows as $data) {
                        $newdata[$data["delivery_type"]] = $data;
                    }
                    break;
                }

            }
        }

        $ws = $this->shippingWsFactory->create();

        foreach ($newdata as $data) {
            $rate = new \stdClass;
            $rate->Service = $data["delivery_type"];
            $rate->ServiceDesc = $ws->getLabelFromShipmentType($data["delivery_type"]);
            $rate->SubzoneDesc = '';
            $rate->IdSubzone = '';

            $rate->NetShipmentTotalPrice = $data["price"];
            $result[] = $rate;

            //rate with insurance
            $rateWithInsurance = new \stdClass;
            $rateWithInsurance->Service = $this->shippingHelper->convertShippingCodeWithInsurance($data["delivery_type"]);
            $rateWithInsurance->ServiceDesc = $this->shippingHelper->convertShippingLabelWithInsurance($ws->getLabelFromShipmentType($data["delivery_type"]));;
            $rateWithInsurance->SubzoneDesc = '';
            $rateWithInsurance->IdSubzone = '';

            $rateWithInsurance->NetShipmentTotalPrice = $this->applyInsuranceToRate($data["price"], $insuranceValue);
            $result[] = $rateWithInsurance;
        }

        return $result;
    }

//    Compatibility with new CsvToFile
//    public function insertRow($row)
//    {
//        $this->insertRate($row["country"], $row["region"], $row["city"], $row["zip"], $row["zip_to"], $row["weight_from"], $row["weight_to"], $row["price"], $row["delivery_type"]);
//    }
}
