<?php
namespace Mbe\Shipping\Model\Source;


class ShipmentServices
{

    /**
     * @var \Mbe\Shipping\Model\WsFactory
     */
    protected $shippingWsFactory;

    public function __construct(
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory
    ) {
        $this->shippingWsFactory = $shippingWsFactory;
    }
    public function toOptionArray()
    {
        /**
         * @var $ws Mbe_Shipping_Model_Ws
         */
        $ws = $this->shippingWsFactory->create();
        $availableShipping = $ws->getAllowedShipmentServices();
        if ($ws->isCustomerActive()) {
            if ($availableShipping) {
                $result = $availableShipping;
            } else {
                $result = array(
                    array('value' => '', 'label' => __('Set ws parameters and save to retrieve available shipment types')),
                );
            }
        } else {
            $result = array(
                array('value' => '', 'label' => __('Your user is not active')),
            );
        }

        return $result;
    }

}