<?php

namespace Mbe\Shipping\Controller\Adminhtml\Shipments;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\NotFoundException;
use Mbe\Shipping\Helper\Data;
use Mbe\Shipping\Model\Ws;

class ReturnShipments extends Action implements HttpPostActionInterface
{
    /**
     * Authorization level of a basic admin session
     */
    const ADMIN_RESOURCE = '';

    protected $shipmentRepository;

    public function __construct(
        Context $context,
        \Mbe\Shipping\Helper\Data $shippingHelper,
        \Mbe\Shipping\Model\WsFactory $shippingWsFactory,
        \Magento\Sales\Model\Order\ShipmentRepository $shipmentRepository
    ) {

        $this->shippingHelper = $shippingHelper;
        $this->shippingWsFactory = $shippingWsFactory;
        $this->shipmentRepository = $shipmentRepository;

        parent::__construct($context);
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     * @throws NotFoundException
     */
    public function execute()
    {

        if (!$this->shippingHelper->isOnlineMBE()) {
            /** @var  $ws Ws */
            $ws = $this->shippingWsFactory->create();

            $toReturnIds = array();
            $alreadyReturnedIds = array();
            $withoutTracking = array();

            $shipmentIds = $this->getRequest()->getParam('shipment_ids');

            foreach ($shipmentIds as $shipmentId) {
                $trackList = $this->shipmentRepository->get($shipmentId)->getTracks();
                if (!$trackList) {
                    array_push($withoutTracking, $shipmentId);
                }
                elseif ($this->shippingHelper->isReturned($trackList)) {
                    array_push($alreadyReturnedIds, $shipmentId);
                }
                else {
                    array_push($toReturnIds, $shipmentId);
                }
            }

            $returnedShipping = $ws->returnShipping($toReturnIds);

            $returnedIds = 0;
            foreach ( $toReturnIds as $return_id ) {
                $returnTrackingMeta = '';
                $returnedTrackings = 0;
                $shipmentEntity = $this->shipmentRepository->get($return_id);
                $trackingList = $shipmentEntity->getTracksCollection()->getColumnValues('track_number');
                $returnedIds += count(array_filter($returnedShipping[$return_id], function($x) { return !empty($x); }));
                foreach ( $trackingList as $tracking ) {
//                    $returnedTrackings += (!empty($returnedShipping[$return_id][$tracking])?1:0);
                    if (!empty($returnedShipping[$return_id][$tracking])) {
                        $returnedTrackings++;
//                        $returnTrackingMeta[$tracking] = $returnedShipping[$return_id][$tracking];
                        $trackingEntity = $this->trackingFactory->create()->addData(
                            [
                                'title' => 'Mbe Return Shipping ('.$tracking.')',
                                'number' => $returnedShipping[$return_id][$tracking],
                                'carrier_code' => 'mbe_shipping',
                            ]
                        );
                        $shipmentEntity->addTrack($trackingEntity);
                    }
                }
                if ($returnedTrackings>0) {
                    $shipmentEntity->save();
                }
            }
            if (count($withoutTracking) > 0) {
                $this->messageManager->addErrorMessage(
                    sprintf(__('%s - Total of %d order(s) without tracking number yet.'), date('Y-m-d H:i:s'), $withoutTracking)
                );
            }

            $messageCreated = sprintf(__('%s - Total of %d return shipments created.', 'mail-boxes-etc'), date('Y-m-d H:i:s'), $returnedIds);
            if ($returnedIds>0) {
                $this->messageManager->addNoticeMessage($messageCreated);
            } else {
                $this->messageManager->addErrorMessage($messageCreated);
            }

            if (count($alreadyReturnedIds) > 0) {
                $this->messageManager->addErrorMessage(
                    sprintf(__('%s - Total of %d order already returned', 'mail-boxes-etc'), date('Y-m-d H:i:s'), $alreadyReturnedIds)
                );
            }

        }
        return $this->_redirect('*/*/index');
    }
}