<?php

namespace Mbe\Shipping\Controller\Adminhtml\System\Config;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Response\Http\FileFactory;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\NotFoundException;
use Magento\Framework\Filesystem;
use Magento\Framework\View\Result\PageFactory;
use Mbe\Shipping\Helper\Data;

class DeleteLog extends Action
{
    protected $resultPageFactory;
    protected $fileSystem;
//    protected $fileFactory;
//    protected $shippingHelper;
    protected $directoryList;

    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Filesystem $fileSystem,
        DirectoryList $directoryList
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->fileSystem = $fileSystem;
        $this->directoryList = $directoryList;
        parent::__construct($context);
    }
    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     * @throws NotFoundException
     */
    public function execute()
    {

        try {
            $folder = $this->fileSystem->getDirectoryWrite(DirectoryList::LOG);
            $deleted = false;

            if ($folder->isFile(Data::MBE_LOG_PLUGIN)) {
                $folder->delete(Data::MBE_LOG_PLUGIN);
                $deleted = true;
            }
            if ($folder->isFile(Data::MBE_LOG_WS)) {
                $folder->delete(Data::MBE_LOG_WS);
                $deleted = true;
            }
            if ($deleted) {
                $this->messageManager->addSuccessMessage(__('Log files deleted'));
            } else {
                $this->messageManager->addSuccessMessage(__('Nothing to delete'));
            }
        } catch (FileSystemException $e) {
            // return error message
            $this->messageManager->addErrorMessage(__('Error deleting log files') . ' - ' . $e->getMessage());
        }

        $this->_redirect('adminhtml/system_config/edit/section/carriers/');
    }
}
