<?php

namespace Mbe\Shipping\Helper;


use FontLib\Table\Type\head;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\RuntimeException;
use Magento\Framework\Phrase;

class Csv extends \Magento\Framework\App\Helper\AbstractHelper
{
    protected $_csvHeaderKnowDefinitions = [
        'country'       => 'country',
        'region'        => 'region',
        'city'          => 'city',
        'zip'           => 'zip',
        'zip_to'        => 'zip_to',
        'weight_from'   => 'weight_from',
        'weight_to'     => 'weight_to',
        'price'         => 'price',
        'delivery_type' => 'delivery_type',
    ];
    protected $driverInterface;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Framework\Filesystem\DriverInterface $driverInterface
    )
    {
        $this->driverInterface = $driverInterface;
        parent::__construct(
            $context
        );
    }

    public function getCsvHeaderKnowDefinitions()
    {
        return $this->_csvHeaderKnowDefinitions;
    }

    /**
     * @throws FileSystemException
     * @throws LocalizedException
     */
    public function readFile($importFilePath, $headerDefinition = [])
    {
        // TODO: Compatibility for Shipping, to be removed when refactored to be compliant to CsvFileToTable
        if (empty($headerDefinition)) {
            $headerDefinition = $this->getCsvHeaderKnowDefinitions();
        }

        $file = $this->driverInterface->fileOpen($importFilePath, "r");
        $i = 0;
        $header = null;
        $result = [];
        while (!$this->driverInterface->endOfFile($file)) {
            $currentRow = $this->driverInterface->fileGetCsv($file, 0, ",", '"');
            if (!empty($currentRow) && ([null]!==$currentRow)) {
                if ($i == 0) {
                    //File heading
                    $header = $currentRow;
                } else {
                    $current = $this->readCsvRowToArray($headerDefinition, $header, $currentRow);
                    $result[] = $current;
                }
            }
            $i++;
        }
        return $result;
    }

    /**
     * @throws LocalizedException
     */
    function readCsvRowToArray($headerDefinition, $header, $row)
    {
        $result = [];
        if (is_array($row) && (count($row) === count($headerDefinition))) {
            foreach ($row as $index => $currentRowValue) {
                $headerName = $this->cleanString($header[$index]);
                $currentKey = $headerName;
                if (isset($headerDefinition[$headerName])) {
                    $currentKey = $headerDefinition[$headerName];
                }
                $currentRowValue = trim($currentRowValue);
                /*
                $currentRowValue = str_replace("  ", " ", $currentRowValue);
                $currentRowValue = str_replace("  ", " ", $currentRowValue);
                $currentRowValue = str_replace("  ", " ", $currentRowValue);
                $currentRowValue = str_replace("„",createShipment "\"", $currentRowValue);
                $currentRowValue = str_replace("“", "\"", $currentRowValue);
                $currentRowValue = str_replace("”", "\"", $currentRowValue);
                */
                $result[$currentKey] = $currentRowValue;
            }
        } else {
            throw new LocalizedException(__(__('The number of columns doesn\'t match the header for line:').json_encode($row)));
        }
        return $result;
    }

    function cleanString($str)
    {
        $result = $str;
        $result = trim($result);
        $result = strtolower($result);
        $result = str_replace(" ", "_", $result);
        $result = str_replace(chr(160), "_", $result);
        $result = str_replace(chr(194), "_", $result);
        $result = str_replace(chr(195), "_", $result);
        $result = str_replace(",", "_", $result);
        $result = str_replace("/", "", $result);
        $result = str_replace("(", "", $result);
        $result = str_replace(")", "", $result);
        $result = str_replace("__", "_", $result);
        return $result;
    }

}
