<?php

namespace Mbe\Shipping\Model\ResourceModel\Packages;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Message\ManagerInterface;

class Collection extends \Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection
{
    protected $_idFieldName = 'id';
    protected $_eventPrefix = 'mbe_shipping_standard_packages_collection';
    protected $_eventObject = 'standard_packages_collection';

    protected $packagesProductResourceFactory;
    protected $messageManager;

    public function __construct(
        \Magento\Framework\Data\Collection\EntityFactoryInterface    $entityFactory,
        \Psr\Log\LoggerInterface                                     $logger,
        \Magento\Framework\Data\Collection\Db\FetchStrategyInterface $fetchStrategy,
        \Magento\Framework\Event\ManagerInterface                    $eventManager,
        \Mbe\Shipping\Model\ResourceModel\PackagesProductFactory     $packagesProductResourceFactory,
        ManagerInterface                                             $messageManager,
        \Magento\Framework\DB\Adapter\AdapterInterface               $connection = null,
        \Magento\Framework\Model\ResourceModel\Db\AbstractDb         $resource = null
    ) {
        $this->packagesProductResourceFactory = $packagesProductResourceFactory;
        $this->messageManager = $messageManager;
        parent::__construct($entityFactory, $logger, $fetchStrategy, $eventManager, $connection, $resource);
    }

    public function getStandardPackages()
    {
        $packagesProductResource = $this->packagesProductResourceFactory->create();
        try {
            $packages_product = $packagesProductResource->getMainTable();
            $this->addFieldToSelect(['package_label', 'id'])
                ->getSelect()
                ->distinct()
                ->joinLeft(
                    $packages_product,
                    "main_table.package_code = $packages_product.package_code",
                    null
                )
                ->where($packages_product . '.custom_package <> true')
                ->orWhere($packages_product . '.custom_package is null')
            ;
            return $this;
        } catch (LocalizedException $e) {
            $this->messageManager->addErrorMessage(__('Main table not set for ') . self::class);
            return $e;
        }
    }

    public function getPackageInfobyProduct($productSku)
    {
        $packagesProduct = $this->packagesProductResourceFactory->create()->getMainTable();
        $this->getSelect()
            ->joinLeft(
                $packagesProduct,
                "main_table.package_code = $packagesProduct.package_code",
                [
                    'id_product' => 'id',
                    'product_sku',
                    'single_parcel',
                    'custom_package',
                ]
            )
            ->where('product_sku = ?', $productSku);
        return $this;
    }

    public function getPackageInfobyId($packageId)
    {
        $this->addExpressionFieldToSelect('single_parcel', '(0)', null)
            ->addExpressionFieldToSelect('custom_package', '(0)', null)
            ->addFieldToFilter('id', $packageId);
        return $this;
    }

    protected function _toOptionArray($valueField = null, $labelField = 'name', $additional = [])
    {
        return parent::_toOptionArray($valueField, 'package_label', $additional);
    }

    /**
     * Define resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(\Mbe\Shipping\Model\Packages::class, \Mbe\Shipping\Model\ResourceModel\Packages::class);
    }
}
