<?php
namespace Mbe\Shipping\Block\Adminhtml\System\Config\Form\Field;

use Magento\Backend\Block\Widget\Button;

class LogDelete extends \Magento\Config\Block\System\Config\Form\Field
{

    /**
     * @var \Mbe\Shipping\Helper\Data
     */
    protected $shippingHelper;
    protected $_template = 'Mbe_Shipping::mbe_shipping/system/config/log-delete-button.phtml';

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        array $data = []
    ) {

        parent::__construct($context, $data);
    }

    protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        return $this->_toHtml();
    }

    public function getButtonHtml()
    {
        $buttonBlock = $this->getLayout()->createBlock(Button::class);

        $data = [
            'id'      => 'delete_log_button',
            'label'   => __('Delete now'),
            'class'   => '',
        ];
        return $buttonBlock->setData($data)->toHtml();
    }

    /**
     * @return string
     */
    public function getDeleteUrl()
    {
        return parent::getUrl('mbe/system_config/deleteLog');
    }

}
