<?php
namespace Mbe\Shipping\Helper;

class Tracking extends \Magento\Framework\App\Helper\AbstractHelper
{
    const ITALIAN_URL = "https://www.mbe.it/it/tracking?c=";
    const SPAIN_URL = "https://www.mbe.es/es/tracking?c=";
    const GERMANY_URL = "https://www.mbe.de/de/tracking?c=";
    const FRANCE_URL = "https://www.mbefrance.fr/fr/suivi?c=";
    const POLSKA_URL = "https://www.mbe.pl/pl/tracking?c=";
    const CROATIA_URL = "https://www.mbe.hr/hr/tracking?c=";
    const AUSTRIA_URL = "https://www.mbe.at/tracking?c=";

    const DEFAULT_URL = "";


    public function getTrackingUrlBySystem($system)
    {
        switch ($system) {
            case "IT":
                return self::ITALIAN_URL;
            case "ES":
                return self::SPAIN_URL;
            case "DE":
                return self::GERMANY_URL;
            case "AT":
                return self::AUSTRIA_URL;
            case "FR":
                return self::FRANCE_URL;
            case "PL":
                return self::POLSKA_URL;
            case "HR":
                return self::CROATIA_URL;
            default:
                return self::DEFAULT_URL;
        }
    }
}

